package com.orhon.smartcampus.material.modules.management.mutation;

import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.management.dao.BuildingsDao;
import com.orhon.smartcampus.material.modules.management.dao.UnitDao;
import com.orhon.smartcampus.material.modules.management.entity.Buildings;
import com.orhon.smartcampus.material.modules.management.entity.Unit;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLBuildingsInput;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLUnitInput;
import com.orhon.smartcampus.material.modules.management.inputMapper.BuildingsInputMapper;
import com.orhon.smartcampus.material.modules.management.inputMapper.UnitInputMapper;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
public class AddUnitMutation implements DataFetcher {


    @Autowired
    UnitDao unitDao;

    /**
     * 楼层管理
     * editor : ths
     */
    @Override
    public Object get(DataFetchingEnvironment environment) throws Exception {

        //String token = (String) SecurityUtils.getSubject().getPrincipal();

        GQLUnitInput input = UnitInputMapper.MAPPER.mapInput(environment.getArgument("inputData"));

        Unit unit = null;

        if (input.getId() != null) {
            unit = unitDao.get(Unit.class, input.getId());
            unit.setUpdated_at(new Date());
        } else {
            unit = new Unit();
            unit.setCreated_at(new Date());
        }
        if(input.getBuilding_id() != null){
            unit.setBuilding_id(input.getBuilding_id());
        }
        if(input.getHead_id() != null){
            unit.setHead_id(input.getHead_id());
        }
        if(input.getFloor_status() != null){
            unit.setFloor_status(input.getFloor_status());
        }
        if(input.getFloor_number()!= null){
            unit.setFloor_number(input.getFloor_number());
        }
        if(input.getAdd_id() != null){
            unit.setAdd_id(input.getAdd_id());
        }
        if(input.getSchool_id() != null){
            unit.setSchool_id(input.getSchool_id());
        }
        try {
            unitDao.saveOrUpdate(unit);
        } catch (Exception e) {
            return Result.error(500, "" + e);
        }
        return Result.ok();
    }
}
