package com.orhon.smartcampus.material.modules.management.mutation;

import com.alibaba.fastjson.JSON;
import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.management.dao.GoodsClassifyDao;
import com.orhon.smartcampus.material.modules.management.dao.RoomDao;
import com.orhon.smartcampus.material.modules.management.entity.GoodsClassify;
import com.orhon.smartcampus.material.modules.management.entity.RoomEntity;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLGoodsClassifyInput;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLRoomInput;
import com.orhon.smartcampus.material.modules.management.inputMapper.GoodsClassifyInputMapper;
import com.orhon.smartcampus.material.modules.management.inputMapper.RoomInputMapper;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
public class AddRoomMutation implements DataFetcher {


    @Autowired
    RoomDao roomDao;

    /**
     * Room管理添加
     * editor : ths
     */
    @Override
    public Object get(DataFetchingEnvironment environment) throws Exception {

        //String token = (String) SecurityUtils.getSubject().getPrincipal();

        GQLRoomInput input = RoomInputMapper.MAPPER.mapInput(environment.getArgument("inputData"));

        RoomEntity roomEntity = null;

        if (input.getId() != null) {
            roomEntity = roomDao.get(RoomEntity.class, input.getId());
            roomEntity.setUpdated_at(new Date());
        } else {
            roomEntity = new RoomEntity();
            roomEntity.setCreated_at(new Date());
        }
        if(input.getAdd_id() != null){

            roomEntity.setAdd_id(input.getAdd_id());
        }
        if(input.getRoom_head() != null){

            roomEntity.setRoom_head(input.getRoom_head());
        }
        if(input.getRoom_list_name() != null){

            roomEntity.setRoom_list_name(input.getRoom_list_name());
        }
        if(!String.valueOf(input.getRoom_status()).equals("null")){

            roomEntity.setRoom_status(input.getRoom_status());
        }
        try {
            roomDao.saveOrUpdate(roomEntity);
        } catch (Exception e) {
            return Result.error(500, "" + e);
        }
        return Result.ok();
    }
}
