package com.orhon.smartcampus.material.modules.management.mutation;

import com.alibaba.fastjson.JSON;
import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.management.dao.GoodsClassifyDao;
import com.orhon.smartcampus.material.modules.management.dao.GoodsManageDao;
import com.orhon.smartcampus.material.modules.management.entity.GoodsClassify;
import com.orhon.smartcampus.material.modules.management.entity.GoodsManage;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLGoodsClassifyInput;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLGoodsManageInput;
import com.orhon.smartcampus.material.modules.management.inputMapper.GoodsClassifyInputMapper;
import com.orhon.smartcampus.material.modules.management.inputMapper.GoodsManageInputMapper;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
public class AddGoodsManageMutation implements DataFetcher {


    @Autowired
    GoodsManageDao goodsManageDao;

    /**
     * 楼层管理
     * editor : ths
     */
    @Override
    public Object get(DataFetchingEnvironment environment) throws Exception {

        //String token = (String) SecurityUtils.getSubject().getPrincipal();

        GQLGoodsManageInput input = GoodsManageInputMapper.MAPPER.mapInput(environment.getArgument("inputData"));

        GoodsManage goodsManage = null;

        if (input.getId() != null) {
            goodsManage = goodsManageDao.get(GoodsManage.class, input.getId());
            goodsManage.setUpdated_at(new Date());
        } else {
            goodsManage = new GoodsManage();
            goodsManage.setCreated_at(new Date());
        }
        if(input.getClassify_id() != null){
            goodsManage.setClassify_id(input.getClassify_id());
        }
        if(input.getGoods_name() != null){
            goodsManage.setGoods_name(input.getGoods_name());
        }
        if(input.getMain_image() != null){
            goodsManage.setMain_image(input.getMain_image());
        }
        if(input.getGoods_number() != null){
            goodsManage.setGoods_number(input.getGoods_number());
        }
        if(input.getGood_status() != null){
            goodsManage.setGood_status(input.getGood_status());
        }
        if(input.getGoods_price() != null){
            goodsManage.setGoods_price(input.getGoods_price());
        }
        if(input.getGoods_stock() != null){
            goodsManage.setGoods_price(input.getGoods_price());
        }
        if(input.getUserid() != null){
            goodsManage.setUserid(input.getUserid());
        }
        if(input.getSchool_id() != null){
            goodsManage.setSchool_id(input.getSchool_id());
        }
        try {
            goodsManageDao.saveOrUpdate(goodsManage);
        } catch (Exception e) {
            return Result.error(500, "" + e);
        }
        return Result.ok();
    }
}
