package com.orhon.smartcampus.material.modules.management.mutation;

import com.alibaba.fastjson.JSON;
import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.management.dao.GoodsClassifyDao;
import com.orhon.smartcampus.material.modules.management.entity.GoodsClassify;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLGoodsClassifyInput;
import com.orhon.smartcampus.material.modules.management.inputMapper.GoodsClassifyInputMapper;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
public class AddGoodsClassifyMutation implements DataFetcher {


    @Autowired
    GoodsClassifyDao goodsClassifyDao;

    /**
     * 楼层管理
     * editor : ths
     */
    @Override
    public Object get(DataFetchingEnvironment environment) throws Exception {

        //String token = (String) SecurityUtils.getSubject().getPrincipal();

        GQLGoodsClassifyInput input = GoodsClassifyInputMapper.MAPPER.mapInput(environment.getArgument("inputData"));

        GoodsClassify goodsClassify = null;

        if (input.getId() != null) {
            goodsClassify = goodsClassifyDao.get(GoodsClassify.class, input.getId());
            goodsClassify.setUpdated_at(new Date());
        } else {
            goodsClassify = new GoodsClassify();
            goodsClassify.setCreated_at(new Date());
        }
        if(input.getClassify_name() != null){

            goodsClassify.setClassify_name(input.getClassify_name());
        }
        if(input.getSchool_id() != null){

            goodsClassify.setSchool_id(input.getSchool_id());
        }
        if(input.getClassify_status() != null){

            goodsClassify.setClassify_status(input.getClassify_status());
        }
        if(input.getAdd_id() != null){

            goodsClassify.setAdd_id(JSON.toJSONString(input.getAdd_id()));
        }
        try {
            goodsClassifyDao.saveOrUpdate(goodsClassify);
        } catch (Exception e) {
            return Result.error(500, "" + e);
        }
        return Result.ok();
    }
}
