package com.orhon.smartcampus.material.modules.management.mutation;

import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.management.dao.FloorDao;
import com.orhon.smartcampus.material.modules.management.dao.RoomDao;
import com.orhon.smartcampus.material.modules.management.entity.FloorEntity;
import com.orhon.smartcampus.material.modules.management.entity.RoomEntity;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLFloorInput;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLRoomInput;
import com.orhon.smartcampus.material.modules.management.inputMapper.FloomInputMapper;
import com.orhon.smartcampus.material.modules.management.inputMapper.RoomInputMapper;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
public class AddFloorMutation implements DataFetcher {


    @Autowired
    FloorDao floorDao;

    /**
     * Room管理添加
     * editor : ths
     */
    @Override
    public Object get(DataFetchingEnvironment environment) throws Exception {

        //String token = (String) SecurityUtils.getSubject().getPrincipal();

        GQLFloorInput input = FloomInputMapper.MAPPER.mapInput(environment.getArgument("inputData"));

        FloorEntity roomEntity = null;

        if (input.getId() != null) {
            roomEntity = floorDao.get(FloorEntity.class, input.getId());
            roomEntity.setUpdated_at(new Date());
        } else {
            roomEntity = new FloorEntity();
            roomEntity.setCreated_at(new Date());
        }
        if(input.getAdd_id() != null){

            roomEntity.setAdd_id(input.getAdd_id());
        }
        if(input.getFloor_head() != null){

            roomEntity.setFloor_head(input.getFloor_head());
        }
        if(input.getFloor_number() != null){

            roomEntity.setFloor_number(input.getFloor_number());
        }
        if(input.getUnit_id() != null){

            roomEntity.setUnit_id(input.getUnit_id());
        }

        try {
            floorDao.saveOrUpdate(roomEntity);
        } catch (Exception e) {
            return Result.error(500, "" + e);
        }
        return Result.ok();
    }
}
