package com.orhon.smartcampus.material.modules.management.mutation;

import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.management.dao.BuildingsDao;
import com.orhon.smartcampus.material.modules.management.dao.GoodsManageDao;
import com.orhon.smartcampus.material.modules.management.entity.Buildings;
import com.orhon.smartcampus.material.modules.management.entity.GoodsManage;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLBuildingsInput;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLGoodsManageInput;
import com.orhon.smartcampus.material.modules.management.inputMapper.BuildingsInputMapper;
import com.orhon.smartcampus.material.modules.management.inputMapper.GoodsManageInputMapper;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
public class AddBuildingsMutation implements DataFetcher {


    @Autowired
    BuildingsDao buildingsDao;

    /**
     * 楼层管理
     * editor : ths
     */
    @Override
    public Object get(DataFetchingEnvironment environment) throws Exception {

        //String token = (String) SecurityUtils.getSubject().getPrincipal();

        GQLBuildingsInput input = BuildingsInputMapper.MAPPER.mapInput(environment.getArgument("inputData"));

        Buildings buildings = null;

        if (input.getId() != null) {
            buildings = buildingsDao.get(Buildings.class, input.getId());
            buildings.setUpdated_at(new Date());
        } else {
            buildings = new Buildings();
            buildings.setCreated_at(new Date());
        }
        if(input.getBuildings_name() != null){
            buildings.setBuildings_name(input.getBuildings_name());
        }
        if(input.getSite_id() != null){
            buildings.setSite_id(input.getSite_id());
        }
        if(input.getBuildings_units() != null){
            buildings.setBuildings_units(input.getBuildings_units());
        }
        if(input.getBuildings_introduce()!= null){
            buildings.setBuildings_introduce(input.getBuildings_introduce());
        }
        if(input.getBuildings_head_id() != null){
            buildings.setBuildings_head_id(input.getBuildings_head_id());
        }
        if(input.getAdd_id() != null){
            buildings.setAdd_id(input.getAdd_id());
        }
        if(input.getSchool_id() != null){
            buildings.setSchool_id(input.getSchool_id());
        }
        try {
            buildingsDao.saveOrUpdate(buildings);
        } catch (Exception e) {
            return Result.error(500, "" + e);
        }
        return Result.ok();
    }
}
