package com.orhon.smartcampus.material.modules.management.mm;

import com.orhon.smartcampus.material.basicComponents.ConvertHelper;
import com.orhon.smartcampus.material.modules.management.entity.GoodsClassify;
import com.orhon.smartcampus.material.modules.management.entity.RootEntity;
import com.orhon.smartcampus.material.modules.management.gqlModel.GQLGoodsClassify;
import com.orhon.smartcampus.material.modules.management.gqlModel.GQLRootBeans;
import org.mapstruct.InheritConfiguration;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

import java.util.List;

@Mapper(
        uses = {
           ConvertHelper.class
        }
)
public interface RootBeanMapper {

    RootBeanMapper MAPPER = Mappers.getMapper(RootBeanMapper.class);


    @Mapping(source = "id" , target = "id")
    @Mapping(source = "site_name" , target = "site_name")
    @Mapping(source = "site_status" , target = "site_status")
    @Mapping(source = "school_id" , target = "school_id")
    @Mapping(source = "add_id" , target = "add_id")
    @Mapping(source = "created_at" , target = "created_at")
    @Mapping(source = "updated_at" , target = "updated_at")
    GQLRootBeans toRootsClassify(RootEntity entity);

    @InheritConfiguration(name = "toGoodsClassify")
    List<GQLRootBeans> toRootList(List<RootEntity> entities);
}
