package com.orhon.smartcampus.material.modules.management.mm;

import com.orhon.smartcampus.material.basicComponents.ConvertHelper;
import com.orhon.smartcampus.material.modules.management.entity.RoomEntity;
import com.orhon.smartcampus.material.modules.management.entity.RootEntity;
import com.orhon.smartcampus.material.modules.management.gqlModel.GQLRootBeans;
import com.orhon.smartcampus.material.modules.management.gqlModel.RoomGqlModel;
import org.mapstruct.InheritConfiguration;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

import java.util.List;

@Mapper(
        uses = {
           ConvertHelper.class
        }
)
public interface RoomMapper {

    RoomMapper MAPPER = Mappers.getMapper(RoomMapper.class);


    @Mapping(source = "id" , target = "id")
    @Mapping(source = "unit_id" , target = "unit_id")
    @Mapping(source = "room_head" , target = "room_head")
    @Mapping(source = "room_key_number" , target = "room_key_number")
    @Mapping(source = "room_number_of" , target = "room_number_of")
    @Mapping(source = "room_list_name" , target = "room_list_name")
    @Mapping(source = "room_status" , target = "room_status")
    @Mapping(source = "add_id" , target = "add_id")
    @Mapping(source = "created_at" , target = "created_at")
    @Mapping(source = "updated_at" , target = "updated_at")
    RoomGqlModel toRoomModel(RoomEntity entity);

    @InheritConfiguration(name = "toRoomList")
    List<RoomGqlModel> toRoomList(List<RoomEntity> entities);
}
