package com.orhon.smartcampus.material.modules.management.mm;

import com.orhon.smartcampus.material.basicComponents.ConvertHelper;
import com.orhon.smartcampus.material.modules.management.entity.FloorEntity;
import com.orhon.smartcampus.material.modules.management.entity.RoomEntity;
import com.orhon.smartcampus.material.modules.management.gqlModel.FloorGqlModel;
import com.orhon.smartcampus.material.modules.management.gqlModel.RoomGqlModel;
import org.mapstruct.InheritConfiguration;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

import java.util.List;

@Mapper(
        uses = {
           ConvertHelper.class
        }
)
public interface FloorMapper {

    FloorMapper MAPPER = Mappers.getMapper(FloorMapper.class);


    @Mapping(source = "id" , target = "id")
    @Mapping(source = "unit_id" , target = "unit_id")
    @Mapping(source = "floor_number" , target = "floor_number")
    @Mapping(source = "floor_head" , target = "floor_head")
    @Mapping(source = "add_id" , target = "add_id")
    @Mapping(source = "created_at" , target = "created_at")
    @Mapping(source = "updated_at" , target = "updated_at")
    FloorGqlModel toFloorModel(FloorEntity entity);

    @InheritConfiguration(name = "toFloorList")
    List<FloorGqlModel> toFloorList(List<FloorEntity> entities);
}
