package com.orhon.smartcampus.material.modules.management.fetcher;

import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.base.gqlModel.GQLPageParam;
import com.orhon.smartcampus.material.modules.base.mm.EnvArgsMapper;
import com.orhon.smartcampus.material.modules.management.dao.GoodsClassifyDao;
import com.orhon.smartcampus.material.modules.management.dao.RootDao;
import com.orhon.smartcampus.material.modules.management.entity.GoodsClassify;
import com.orhon.smartcampus.material.modules.management.entity.RootEntity;
import com.orhon.smartcampus.material.modules.management.gqlModel.GQLGoodsClassify;
import com.orhon.smartcampus.material.modules.management.gqlModel.GQLRootBeans;
import com.orhon.smartcampus.material.modules.management.inputMapper.RootInputMapper;
import com.orhon.smartcampus.material.modules.management.mm.GoodsClassifyMapper;
import com.orhon.smartcampus.material.modules.management.mm.RootBeanMapper;
import com.orhon.smartcampus.material.utils.ObjectToMap;
import com.orhon.smartcampus.material.utils.Util;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;

@Component
public class SiteListFetcher implements DataFetcher {

    @Autowired
    RootDao rootDao;

    @Override
    public Object get(DataFetchingEnvironment env) throws Exception {

        // + schoolId
        String hql = "from RootEntity";

        GQLPageParam page = EnvArgsMapper.MAPPER.fromArgs(env);

        if(env.containsArgument("condition")) {
            HashMap<String,Object> map = ObjectToMap.to(env.getArgument("condition"));
            if(map.get("site_name")!=null) {
                hql += "and site_name " + Util.decide(map.get("site_name"));
            }
            if(map.get("site_status")!=null) {
                hql += "and site_status " + Util.decide(map.get("site_status"));
            }
            if(map.get("school_id")!=null) {
                hql += "and  school_id  " + Util.decide(map.get("school_id"));
            }
            if(map.get("add_id")!=null) {
                hql += "and  add_id  " + Util.decide(map.get("add_id"));
            }
        }

        List<RootEntity> list = rootDao.find(hql,null,page.getPage(),page.getLimit());

        //            GQLGoodsClassify gqlGoodsClassify = null;
        //            if (env.getSelectionSet().contains("data/classify")){
        //                GoodsClassify goodsClassify = item.getBaseSchoolsBySchoolId();
        //                GgqlSchool = SchoolMapper.MAPPER.toSchool(schools);
        //            }
        //
        //            GQLUnit gqlUnit=null;
        //            if (env.getSelectionSet().contains("data/unit")){
        //                Unit unit = item.getMaterialUnitByUnitId();
        //                gqlUnit = UnitMapper.MAPPER.toUnit(unit);
        //            }
        //
        //            GQL floor = FloorMapper.MAPPER.toFloor(item);
        //            floor.setSchool(GgqlSchool);
        //            floor.setUnit(gqlUnit);
        //            GQLFloor.add(floor);
//        List<GQLGoodsClassify> GQLFloor = new ArrayList<>();
//
//        for (GQLGoodsClassify item : list) {
//         //   GQLGoodsClassify gqlGoodsClassify = GoodsClassifyMapper.MAPPER.toGoodsClassifyList(item);
//         //   GQLFloor.add(gqlGoodsClassify);
//        }
        List<GQLRootBeans> gqlGoodsClassifies =  RootBeanMapper.MAPPER.toRootList(list);
        Long total = 0L;
        if (env.getSelectionSet().contains("total")){
            total = rootDao.getTotalCount(hql);
        }
        return Result.ok().put("data", gqlGoodsClassifies).put("total", total);
    }
}
