package com.orhon.smartcampus.material.modules.management.fetcher;

import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.base.gqlModel.GQLPageParam;
import com.orhon.smartcampus.material.modules.base.mm.EnvArgsMapper;
import com.orhon.smartcampus.material.modules.management.dao.FloorDao;
import com.orhon.smartcampus.material.modules.management.dao.RoomDao;
import com.orhon.smartcampus.material.modules.management.entity.FloorEntity;
import com.orhon.smartcampus.material.modules.management.entity.RoomEntity;
import com.orhon.smartcampus.material.modules.management.gqlModel.FloorGqlModel;
import com.orhon.smartcampus.material.modules.management.gqlModel.RoomGqlModel;
import com.orhon.smartcampus.material.modules.management.mm.FloorMapper;
import com.orhon.smartcampus.material.modules.management.mm.RoomMapper;
import com.orhon.smartcampus.material.utils.ObjectToMap;
import com.orhon.smartcampus.material.utils.Util;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;

@Component
public class SeleFloorListFetcher implements DataFetcher {

    @Autowired
    FloorDao floorDao;

    @Override
    public Object get(DataFetchingEnvironment env) throws Exception {

        // + schoolId
        String hql = "from FloorEntity";

        GQLPageParam page = EnvArgsMapper.MAPPER.fromArgs(env);

        if(env.containsArgument("condition")) {
            HashMap<String,Object> map = ObjectToMap.to(env.getArgument("condition"));
            if(map.get("id")!=null) {
                hql += "and id " + Util.decide(map.get("id"));
            }
            if(map.get("unit_id")!=null) {
                hql += "and unit_id " + Util.decide(map.get("unit_id"));
            }
            if(map.get("floor_number")!=null) {
                hql += "and  floor_number  " + Util.decide(map.get("floor_number"));
            }
            if(map.get("floor_head")!=null) {
                hql += "and  floor_head  " + Util.decide(map.get("floor_head"));
            }
            if(map.get("add_id")!=null) {
                hql += "and  add_id  " + Util.decide(map.get("add_id"));
            }
        }

        List<FloorEntity> list = floorDao.find(hql,null,page.getPage(),page.getLimit());

        //            GQLGoodsClassify gqlGoodsClassify = null;
        //            if (env.getSelectionSet().contains("data/classify")){
        //                GoodsClassify goodsClassify = item.getBaseSchoolsBySchoolId();
        //                GgqlSchool = SchoolMapper.MAPPER.toSchool(schools);
        //            }
        //
        //            GQLUnit gqlUnit=null;
        //            if (env.getSelectionSet().contains("data/unit")){
        //                Unit unit = item.getMaterialUnitByUnitId();
        //                gqlUnit = UnitMapper.MAPPER.toUnit(unit);
        //            }
        //
        //            GQL floor = FloorMapper.MAPPER.toFloor(item);
        //            floor.setSchool(GgqlSchool);
        //            floor.setUnit(gqlUnit);
        //            GQLFloor.add(floor);
//        List<GQLGoodsClassify> GQLFloor = new ArrayList<>();
//
//        for (GQLGoodsClassify item : list) {
//         //   GQLGoodsClassify gqlGoodsClassify = GoodsClassifyMapper.MAPPER.toGoodsClassifyList(item);
//         //   GQLFloor.add(gqlGoodsClassify);
//        }
        List<FloorGqlModel> gqlGoodsClassifies =  FloorMapper.MAPPER.toFloorList(list);
        Long total = 0L;
        if (env.getSelectionSet().contains("total")){
            total = floorDao.getTotalCount(hql);
        }
        return Result.ok().put("data", gqlGoodsClassifies).put("total", total);
    }
}
