package com.orhon.smartcampus.material.modules.management.fetcher;

import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.base.gqlModel.GQLPageParam;
import com.orhon.smartcampus.material.modules.base.mm.EnvArgsMapper;
import com.orhon.smartcampus.material.modules.management.dao.BuildingsDao;
import com.orhon.smartcampus.material.modules.management.dao.GoodsManageDao;
import com.orhon.smartcampus.material.modules.management.entity.Buildings;
import com.orhon.smartcampus.material.modules.management.entity.GoodsManage;
import com.orhon.smartcampus.material.modules.management.gqlModel.GQLBuildings;
import com.orhon.smartcampus.material.modules.management.gqlModel.GQLGoodsManage;
import com.orhon.smartcampus.material.modules.management.mm.BuildingsMapper;
import com.orhon.smartcampus.material.modules.management.mm.GoodsManageMapper;
import com.orhon.smartcampus.material.utils.ObjectToMap;
import com.orhon.smartcampus.material.utils.Util;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;

@Component
public class BuildingsListFetcher implements DataFetcher {

    @Autowired
    BuildingsDao buildingsDao;

    @Override
    public Object get(DataFetchingEnvironment env) throws Exception {

        // + schoolId
        String hql = "from Buildings";

        GQLPageParam page = EnvArgsMapper.MAPPER.fromArgs(env);

        if (env.containsArgument("condition")) {
            HashMap<String, Object> map = ObjectToMap.to(env.getArgument("condition"));
            if (map.get("id") != null) {
                hql += "and id " + Util.decide(map.get("id"));
            }
            if (map.get("buildings_name") != null) {
                hql += "and buildings_name " + Util.decide(map.get("buildings_name"));
            }
            if (map.get("buildings_status") != null) {
                hql += "and  buildings_status  " + Util.decide(map.get("buildings_status"));
            }
        }

        List<Buildings> list = buildingsDao.find(hql, null, page.getPage(), page.getLimit());

        List<GQLBuildings> gqlGoodsClassifies = BuildingsMapper.MAPPER.toBuildingsList(list);
        Long total = 0L;
        if (env.getSelectionSet().contains("total")) {
            total = buildingsDao.getTotalCount(hql);
        }
        return Result.ok().put("data", gqlGoodsClassifies).put("total", total);
    }
}
