package com.orhon.smartcampus.material.basicComponents.router;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.orhon.smartcampus.material.gql.scalars.ExtendedScalars;
//import com.orhon.smartcampus.material.modules.management.fetcher.GoodsClassifyFetcher;
//import com.orhon.smartcampus.material.modules.management.fetcher.MaterialFetchersLoader;
//import com.orhon.smartcampus.modules.base.fetcher.BaseFetchersLoader;
//import com.orhon.smartcampus.modules.baseinfo.fetcher.BaseInfoFetcherLoader;
//import com.orhon.smartcampus.modules.gql.fetcher.UserDetailsFetcher;
//import com.orhon.smartcampus.modules.gql.scalars.ExtendedScalars;
//import com.orhon.smartcampus.modules.material.fetcher.MaterialFetchersLoader;
//import com.orhon.smartcampus.modules.student.fetcher.StudentFetchersLoader;
//import com.orhon.smartcampus.modules.systemctl.fetcher.SystemCtlFetchersLoader;
//import com.orhon.smartcampus.modules.teacher.fetcher.TeacherFetchersLoader;
//import com.orhon.smartcampus.modules.user.fetcher.UserFetchersLoader;
import com.orhon.smartcampus.material.modules.management.fetcher.MaterialFetchersLoader;
import graphql.schema.*;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URL;
import java.util.Date;

/**
 * 整合第三方工具，整合springboot
 * 2019年
 *
 * @Author M
 */

@Component
public class SpringBootStart {

	protected final static String TYPE_QUERY = "Query";
	protected final static String TYPE_MUTATION = "Mutation";

	public final static String SCHEMA_ROOT = "graphql/root.graphqls";
	public final static String SCHEMA_BASIC = "graphql/basic.graphqls";
//	public final static String SCHEMA_USER = "graphql/user.graphqls";
//	public final static String SCHEMA_TEACHER = "graphql/teacher.graphqls";
//	public final static String SCHEMA_STUDENT = "graphql/student.graphqls";
//	public final static String SCHEMA_ECLASS = "graphql/eclass.graphqls";
	public final static String SCHEMA_MATERIAL = "graphql/material.graphqls";
	public final static String SCHEMA_SITE = "graphql/site.graphqls";
	public final static String SCHEMA_ROOM = "graphql/room.graphqls";
	public final static String SCHEMA_FLOOR = "graphql/floor.graphqls";
//	public final static String SCHEMA_SCHOOLBASEINFO= "graphql/schoolbaseinfo.graphqls";
//	public final static String SCHEMA_SYSTEMCTL= "graphql/systemctl.graphqls";
//	public final static String SCHEMA_STATISTICS= "graphql/teacherstatistics.graphqls";


//	@Autowired
//	SystemCtlFetchersLoader systemCtlFetchersLoader;

//	@Autowired
//	UserFetchersLoader userFetchersLoaderl;
//
//	@Autowired
//	StudentFetchersLoader studentFetchersLoader;
//
//	@Autowired
//	TeacherFetchersLoader teacherFetchersLoader;
//
//	@Autowired
//	BaseInfoFetcherLoader baseInfoFetcherLoader;
//
//	@Autowired
//	BaseFetchersLoader baseFetchersLoader;

	@Autowired
	MaterialFetchersLoader materialFetchersLoader;

	@Bean
	public GraphQLSchema schema() throws IOException {
		GraphQLSchema schema = loadSchma();
		return schema;
	}

	public void init(){

	}


	/**
	 * 定义schema文件列表...
	 */
	protected  String[] getSchemas(){
		return new String[]{SCHEMA_ROOT , SCHEMA_BASIC ,SCHEMA_MATERIAL,SCHEMA_SITE,SCHEMA_ROOM,SCHEMA_FLOOR};
		//return new String[]{SCHEMA_ROOT , SCHEMA_BASIC ,SCHEMA_USER , SCHEMA_TEACHER ,SCHEMA_STUDENT, SCHEMA_ECLASS,SCHEMA_MATERIAL, SCHEMA_SCHOOLBASEINFO,SCHEMA_SYSTEMCTL,SCHEMA_STATISTICS };
	}

	/**
	 * 获取graphql schema结构...
	 */
	private GraphQLSchema loadSchma() throws IOException {
		SchemaParser parser = new SchemaParser();
		SchemaGenerator generator = new SchemaGenerator();
		String[] fileList = getSchemas();
		TypeDefinitionRegistry typeRegistry = new TypeDefinitionRegistry();
		for(String current: fileList) {
			String schemaSDL = loadSchemaFile(current);
			typeRegistry.merge(parser.parse(schemaSDL));
		}
		GraphQLSchema schema = generator.makeExecutableSchema(typeRegistry, buildDynamicRuntimeWiring());
		return schema;
	}

	/**
	 * 加载schema文件
	 * @param fileName
	 * @return
	 * @throws IOException
	 */
	protected String loadSchemaFile(String fileName) throws IOException {
		URL url = Resources.getResource(fileName);
		String sdl = Resources.toString(url, Charsets.UTF_8);
		return sdl;
	}


	/**
	 * 自定义变量 ， 本办法在框架中被抛弃，需要重构　。。。
	 */
	public static final GraphQLScalarType GQLDate = new GraphQLScalarType("Date" , "" , new Coercing(){

		@Override
		public Object serialize(Object dataFetcherResult) throws CoercingSerializeException {
			Date d = (Date)dataFetcherResult;
			Long orgData = d.getTime();
			return orgData / 1000;
		}

		@Override
		public Object parseValue(Object input) throws CoercingParseValueException {
			return input;
		}

		@Override
		public Object parseLiteral(Object input) throws CoercingParseLiteralException {
			return input;
		}
	});


	protected RuntimeWiring buildDynamicRuntimeWiring() {
		RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring();

		//builder.scalar(GQLDate);
		builder.scalar(ExtendedScalars.Time);
		builder.scalar(ExtendedScalars.DateTime);
		builder.scalar(ExtendedScalars.Date);
		builder.scalar(ExtendedScalars.Json);
		builder.scalar(ExtendedScalars.Object);
		builder.scalar(ExtendedScalars.Locale);

		builder.type(TYPE_QUERY , typeWiring-> typeWiring.dataFetcher("hello" , new StaticDataFetcher("world")));
		//builder.type(TYPE_QUERY , typeWiring-> typeWiring.dataFetcher("user" , UserDetailsFetcher.detailFetcher));
//
//		//系统设置加载..
//		systemCtlFetchersLoader.LoadFetchers(builder);
//		//用户fetchers加载
//		userFetchersLoaderl.LoadFetchers(builder);
//		//学生fetchers加载
//		studentFetchersLoader.LoadFetchers(builder);
//		//教师fetchers加载
//		teacherFetchersLoader.LoadFetchers(builder);
//		//baseinfo fetchers load
//		baseInfoFetcherLoader.LoadFetchers(builder);
//		//base  fetchers 加载
//		baseFetchersLoader.LoadFetchers(builder);
		//material fetcher 加载
		materialFetchersLoader.LoadFetchers(builder);

		return builder.build();
	}
}
