package com.orhon.smartcampus.material.modules.management.mutation;

import com.orhon.smartcampus.material.auth.JwtUtils;
import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.base.user.TokenService;
import com.orhon.smartcampus.material.modules.management.dao.BuildingsDao;
import com.orhon.smartcampus.material.modules.management.dao.UnitDao;
import com.orhon.smartcampus.material.modules.management.entity.Buildings;
import com.orhon.smartcampus.material.modules.management.entity.Unit;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLBuildingsInput;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLUnitInput;
import com.orhon.smartcampus.material.modules.management.inputMapper.BuildingsInputMapper;
import com.orhon.smartcampus.material.modules.management.inputMapper.UnitInputMapper;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
public class AddUnitMutation implements DataFetcher {


    @Autowired
    UnitDao unitDao;

    @Autowired
    TokenService tokenService;
    /**
     * 楼层管理
     * editor : ths
     */
    @Override
    public Object get(DataFetchingEnvironment environment) throws Exception {

        String token = tokenService.getSystemToken();
        Long schoolId = JwtUtils.getSchoolId(token);
        Long userId = JwtUtils.getUserId(token);

        GQLUnitInput input = UnitInputMapper.MAPPER.mapInput(environment.getArgument("inputData"));

        Unit unit = null;

        if (input.getId() != null) {
            unit = unitDao.get(Unit.class, input.getId());
            unit.setUpdated_at(new Date());
        } else {
            String hql = "SELECT unit_name FROM Unit where unit_name = " + "'" + input.getUnit_name() + "'";
            int size = unitDao.find(hql).size();
            if (size > 0){
                return Result.error("场地分类名称重复");
            }
            unit = new Unit();
            unit.setCreated_at(new Date());
        }
        if(input.getBuilding_id() != null){
            unit.setBuilding_id(input.getBuilding_id());
        }
        if(input.getUnit_head() != null){
            unit.setUnit_head(input.getUnit_head());
        }
        if(input.getUnit_name() != null){
            unit.setUnit_name(input.getUnit_name());
        }
        if(input.getUnit_status() != null){
            unit.setUnit_status(input.getUnit_status());
        }
        if(input.getFloor_start()!= null){
            unit.setFloor_start(input.getFloor_start());
        }
        if(input.getFloor_end() != null){
            unit.setFloor_end(input.getFloor_end());
        }
            unit.setAdd_id(String.valueOf(userId));
        try {
            unitDao.saveOrUpdate(unit);
        } catch (Exception e) {
            return Result.error(500, "" + e);
        }
        return Result.ok();
    }
}
