package com.orhon.smartcampus.material.modules.management.mutation;

import com.alibaba.fastjson.JSON;
import com.orhon.smartcampus.material.auth.JwtUtils;
import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.base.user.TokenService;
import com.orhon.smartcampus.material.modules.management.dao.GoodsClassifyDao;
import com.orhon.smartcampus.material.modules.management.dao.RootDao;
import com.orhon.smartcampus.material.modules.management.entity.GoodsClassify;
import com.orhon.smartcampus.material.modules.management.entity.RootEntity;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLGoodsClassifyInput;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLRoomInput;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLRootInput;
import com.orhon.smartcampus.material.modules.management.gqlModel.GQLRootBeans;
import com.orhon.smartcampus.material.modules.management.inputMapper.GoodsClassifyInputMapper;
import com.orhon.smartcampus.material.modules.management.inputMapper.RoomInputMapper;
import com.orhon.smartcampus.material.modules.management.inputMapper.RootInputMapper;
import com.orhon.smartcampus.material.utils.ObjectToMap;
import com.orhon.smartcampus.material.utils.Util;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

@Component
public class AddRootSiteMutation implements DataFetcher {


    @Autowired
    RootDao rootDao;

    @Autowired
    TokenService tokenService;
    /**
     * 楼层管理
     * editor : ths
     */
    @Override
    public Object get(DataFetchingEnvironment environment) throws Exception {

        //String token = (String) SecurityUtils.getSubject().getPrincipal();
//        try {
//        GQLRootBeans input = RootInputMapper.MAPPER.mapInput(environment.getArgument("inputData"));
//        String hql = "from RootEntity as site  where 1=1";
//        RootEntity goodsClassify = null;
//        if(environment.containsArgument("inputData")){
//            HashMap<String,Object> map = ObjectToMap.to(environment.getArgument("inputData"));
//            if(map.get("site_name")!=null){
//                hql+= "and site.site_name" + Util.decide(map.get("site_name"));
//            }
//            if(map.get("school_id")!=null){
//                hql+= "and site.school_id" + Util.decide(map.get("school_id"));
//            }
//            if(map.get("add_id")!=null){
//                hql+= "and site.add_id" + Util.decide(map.get("add_id"));
//            }
//        }
//        List<RootEntity> rootEntityList =  rootDao.find(hql,null);
//        if(rootEntityList==null||rootEntityList.size()<=0){
//            goodsClassify = rootEntityList.get(0);
//            goodsClassify.setUpdated_at(new Date());
//        }else{
//            goodsClassify = new RootEntity();
//            goodsClassify.setCreated_at(new Date());
//        }
//        if(!String.valueOf(input.getSchool_id()).equals("null")){
//            goodsClassify.setSchool_id(input.getSchool_id());
//        }
//        if(!String.valueOf(input.getAdd_id()).equals("null")){
//            goodsClassify.setAdd_id(input.getAdd_id());
//        }
//        if(!String.valueOf(input.getSite_name()).equals("null")){
//            goodsClassify.setSite_name(input.getSite_name());
//        }
//        if(input.getSite_status() != null){
//            goodsClassify.setSite_status(input.getSite_status());
//        }
//        rootDao.saveOrUpdate(goodsClassify);
//        } catch (Exception e) {
//            return Result.error(500, "" + e);
//        }

        String token = tokenService.getSystemToken();
        Long schoolId = JwtUtils.getSchoolId(token);
        Long userId = JwtUtils.getUserId(token);

        GQLRootBeans input = RootInputMapper.MAPPER.mapInput(environment.getArgument("inputData"));


        RootEntity rootEntity = null;

        if (input.getId() != null) {
            rootEntity = rootDao.get(RootEntity.class, input.getId());
            rootEntity.setUpdated_at(new Date());
        } else {
            String hql = "SELECT site_name FROM RootEntity where site_name = " + "'" + input.getSite_name() + "'";
            int size = rootDao.find(hql).size();
            if (size > 0){
                return Result.error("场地分类名称重复");
            }
            rootEntity = new RootEntity();
            rootEntity.setCreated_at(new Date());
        }
        if(input.getParent_id() != null){
            rootEntity.setParent_id(input.getParent_id());
        }
        if(input.getSite_name() != null){
            rootEntity.setSite_name(input.getSite_name());
        }
        if(input.getSite_status() != null){
            rootEntity.setSite_status(input.getSite_status());
        }
        if(input.getSort_order() != null){
            rootEntity.setSort_order(input.getSort_order());
        }
            rootEntity.setSchool_id(String.valueOf(schoolId));
            rootEntity.setAdd_id(String.valueOf(userId));
        try {
            rootDao.saveOrUpdate(rootEntity);
        } catch (Exception e) {
            return Result.error(500, "" + e);
        }
        return Result.ok();
    }
}
