package com.orhon.smartcampus.material.modules.management.mutation;

import com.alibaba.fastjson.JSON;
import com.orhon.smartcampus.material.auth.JwtUtils;
import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.base.user.TokenService;
import com.orhon.smartcampus.material.modules.management.dao.GoodsClassifyDao;
import com.orhon.smartcampus.material.modules.management.dao.RoomDao;
import com.orhon.smartcampus.material.modules.management.entity.GoodsClassify;
import com.orhon.smartcampus.material.modules.management.entity.RoomEntity;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLGoodsClassifyInput;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLRoomInput;
import com.orhon.smartcampus.material.modules.management.inputMapper.GoodsClassifyInputMapper;
import com.orhon.smartcampus.material.modules.management.inputMapper.RoomInputMapper;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
public class AddRoomMutation implements DataFetcher {


    @Autowired
    RoomDao roomDao;

    @Autowired
    TokenService tokenService;
    /**
     * Room管理添加
     * editor : ths
     */
    @Override
    public Object get(DataFetchingEnvironment environment) throws Exception {

        String token = tokenService.getSystemToken();
        Long schoolId = JwtUtils.getSchoolId(token);
        Long userId = JwtUtils.getUserId(token);

        GQLRoomInput input = RoomInputMapper.MAPPER.mapInput(environment.getArgument("inputData"));

        RoomEntity roomEntity = null;

        if (input.getId() != null) {
            roomEntity = roomDao.get(RoomEntity.class, input.getId());
            roomEntity.setUpdated_at(new Date());
        } else {
            String hql = "SELECT room_name FROM RoomEntity where room_name = " + "'" + input.getRoom_name() + "'";
            int size = roomDao.find(hql).size();
            if (size > 0){
                return Result.error("房间名称重复");
            }
            roomEntity = new RoomEntity();
            roomEntity.setCreated_at(new Date());
        }
        if(input.getFloor_id() != null){
            roomEntity.setFloor_id(input.getFloor_id());
        }
        if(input.getRoom_head() != null){
            roomEntity.setRoom_head(input.getRoom_head());
        }
        if(input.getRoom_key() != null){
            roomEntity.setRoom_key(input.getRoom_key());
        }
        if(input.getRoom_number() != null){
            roomEntity.setRoom_number(input.getRoom_number());
        }
        if(input.getRoom_name() != null){
            roomEntity.setRoom_name(input.getRoom_name());
        }
        if(input.getRoom_user() != null){
            roomEntity.setRoom_user(input.getRoom_user());
        }
        if(input.getRoom_status() != null){
            roomEntity.setRoom_status(input.getRoom_status());
        }
            roomEntity.setAdd_id(String.valueOf(userId));
        try {
            roomDao.saveOrUpdate(roomEntity);
        } catch (Exception e) {
            return Result.error(500, "" + e);
        }
        return Result.ok();
    }
}
