package com.orhon.smartcampus.material.modules.management.mutation;

import com.alibaba.fastjson.JSON;
import com.orhon.smartcampus.material.auth.JwtUtils;
import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.base.user.TokenService;
import com.orhon.smartcampus.material.modules.management.dao.GoodsClassifyDao;
import com.orhon.smartcampus.material.modules.management.dao.GoodsManageDao;
import com.orhon.smartcampus.material.modules.management.entity.GoodsClassify;
import com.orhon.smartcampus.material.modules.management.entity.GoodsManage;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLGoodsClassifyInput;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLGoodsManageInput;
import com.orhon.smartcampus.material.modules.management.inputMapper.GoodsClassifyInputMapper;
import com.orhon.smartcampus.material.modules.management.inputMapper.GoodsManageInputMapper;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.UUID;

@Component
public class AddGoodsManageMutation implements DataFetcher {


    @Autowired
    GoodsManageDao goodsManageDao;

    @Autowired
    TokenService tokenService;
    /**
     * 楼层管理
     * editor : ths
     */
    @Override
    public Object get(DataFetchingEnvironment environment) throws Exception {

        String token = tokenService.getSystemToken();
        Long schoolId = JwtUtils.getSchoolId(token);
        Long userId = JwtUtils.getUserId(token);

        GQLGoodsManageInput input = GoodsManageInputMapper.MAPPER.mapInput(environment.getArgument("inputData"));


        GoodsManage goodsManage = null;

        if (input.getId() != null) {
            goodsManage = goodsManageDao.get(GoodsManage.class, input.getId());
            goodsManage.setUpdated_at(new Date());
        } else {
            String hql = "SELECT goods_name FROM GoodsManage where goods_name = " + "'" + input.getGoods_name() + "'";
            int size = goodsManageDao.find(hql).size();
            if (size > 0){
                return Result.error("物品名称重复");
            }
            goodsManage = new GoodsManage();
            goodsManage.setCreated_at(new Date());
        }
        if(input.getClassify_id() != null){
            goodsManage.setClassify_id(input.getClassify_id());
        }
        if(input.getGoods_name() != null){
            goodsManage.setGoods_name(input.getGoods_name());
        }
        if(input.getMain_image() != null){
            goodsManage.setMain_image(input.getMain_image());
        }
        if(input.getSub_images() != null){
            goodsManage.setSub_images(input.getSub_images());
        }
        if(input.getGoods_price() != null){
            goodsManage.setGoods_price(input.getGoods_price());
        }
        goodsManage.setGoods_number(UUID.randomUUID().toString().substring(24));
        if(input.getGoods_stock() != null){
            goodsManage.setGoods_stock(input.getGoods_stock());
        }
        if(input.getGoods_note() != null){
            goodsManage.setGoods_note(input.getGoods_note());
        }
        if(input.getGoods_status() != null){
            goodsManage.setGoods_status(input.getGoods_status());
        }
        goodsManage.setAdd_id(String.valueOf(userId));
        if(input.getEmploy_time() != null){
            goodsManage.setEmploy_time(input.getEmploy_time());
        }
        if(input.getEmploy_department() != null){
            goodsManage.setEmploy_department(input.getEmploy_department());
        }
        try {
            goodsManageDao.saveOrUpdate(goodsManage);
        } catch (Exception e) {
            return Result.error(500, "" + e);
        }
        return Result.ok();
    }
}
