package com.orhon.smartcampus.material.modules.management.mutation;

import com.alibaba.fastjson.JSON;
import com.orhon.smartcampus.material.auth.JwtUtils;
import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.base.user.TokenService;
import com.orhon.smartcampus.material.modules.management.dao.GoodsClassifyDao;
import com.orhon.smartcampus.material.modules.management.entity.GoodsClassify;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLFloorInput;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLGoodsClassifyInput;
import com.orhon.smartcampus.material.modules.management.inputMapper.FloomInputMapper;
import com.orhon.smartcampus.material.modules.management.inputMapper.GoodsClassifyInputMapper;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
public class AddGoodsClassifyMutation implements DataFetcher {


    @Autowired
    GoodsClassifyDao goodsClassifyDao;

    @Autowired
    TokenService tokenService;
    /**
     * 楼层管理
     * editor : ths
     */
    @Override
    public Object get(DataFetchingEnvironment environment) throws Exception {

        String token = tokenService.getSystemToken();
        Long schoolId = JwtUtils.getSchoolId(token);
        Long userId = JwtUtils.getUserId(token);

        GQLGoodsClassifyInput input = GoodsClassifyInputMapper.MAPPER.mapInput(environment.getArgument("inputData"));


        GoodsClassify goodsClassify = null;

        if (input.getId() != null) {
            goodsClassify = goodsClassifyDao.get(GoodsClassify.class, input.getId());
            goodsClassify.setUpdated_at(new Date());
        } else {
            String hql = "SELECT classify_name FROM GoodsClassify where classify_name = " + "'" + input.getClassify_name() + "'";
            int size = goodsClassifyDao.find(hql).size();
            if (size > 0){
                return Result.error("分类名称重复");
            }
            goodsClassify = new GoodsClassify();
            goodsClassify.setCreated_at(new Date());
        }
        if(input.getParent_id() != null){
            goodsClassify.setParent_id(input.getParent_id());
        }
        if(input.getClassify_name() != null){
            goodsClassify.setClassify_name(input.getClassify_name());
        }
        if(input.getClassify_status() != null){
            goodsClassify.setClassify_status(input.getClassify_status());
        }
        if(input.getSort_order() != null){
            goodsClassify.setSort_order(input.getSort_order());
        }
            goodsClassify.setSchool_id(String.valueOf(schoolId));
            goodsClassify.setAdd_id(String.valueOf(userId));
        try {
            goodsClassifyDao.saveOrUpdate(goodsClassify);
        } catch (Exception e) {
            return Result.error(500, "" + e);
        }
        return Result.ok();
    }
}
