package com.orhon.smartcampus.material.modules.management.mutation;

import com.orhon.smartcampus.material.auth.JwtUtils;
import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.base.user.TokenService;
import com.orhon.smartcampus.material.modules.management.dao.FloorDao;
import com.orhon.smartcampus.material.modules.management.dao.RoomDao;
import com.orhon.smartcampus.material.modules.management.entity.FloorEntity;
import com.orhon.smartcampus.material.modules.management.entity.RoomEntity;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLFloorInput;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLRoomInput;
import com.orhon.smartcampus.material.modules.management.inputMapper.FloomInputMapper;
import com.orhon.smartcampus.material.modules.management.inputMapper.RoomInputMapper;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
public class AddFloorMutation implements DataFetcher {


    @Autowired
    FloorDao floorDao;

    @Autowired
    TokenService tokenService;
    /**
     * Room管理添加
     * editor : ths
     */
    @Override
    public Object get(DataFetchingEnvironment environment) throws Exception {

        String token = tokenService.getSystemToken();
        Long schoolId = JwtUtils.getSchoolId(token);
        Long userId = JwtUtils.getUserId(token);

        GQLFloorInput input = FloomInputMapper.MAPPER.mapInput(environment.getArgument("inputData"));



        FloorEntity roomEntity = null;

        if (input.getId() != null) {
            roomEntity = floorDao.get(FloorEntity.class, input.getId());
            roomEntity.setUpdated_at(new Date());
        } else {
            String hql = "SELECT floor_name FROM FloorEntity where floor_name = " + "'" + input.getFloor_name() + "'";
            int size = floorDao.find(hql).size();
            if (size > 0){
                return Result.error("楼层名称重复");
            }
            roomEntity = new FloorEntity();
            roomEntity.setCreated_at(new Date());
        }
        if(input.getUnit_id() != null){
            roomEntity.setUnit_id(input.getUnit_id());
        }
        if(input.getFloor_name() != null){
            roomEntity.setFloor_name(input.getFloor_name());
        }
        if(input.getFloor_head() != null){
            roomEntity.setFloor_head(input.getFloor_head());
        }
        if(input.getFloor_status() != null){
            roomEntity.setFloor_status(input.getFloor_status());
        }
            roomEntity.setAdd_id(String.valueOf(userId));
        try {
            floorDao.saveOrUpdate(roomEntity);
        } catch (Exception e) {
            return Result.error(500, "" + e);
        }
        return Result.ok();
    }
}
