package com.orhon.smartcampus.material.modules.management.mutation;

import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.base.gqlModel.GQLPageParam;
import com.orhon.smartcampus.material.modules.base.mm.EnvArgsMapper;
import com.orhon.smartcampus.material.modules.base.user.TokenService;
import com.orhon.smartcampus.material.modules.management.dao.BuildingsDao;
import com.orhon.smartcampus.material.modules.management.entity.Buildings;
import com.orhon.smartcampus.material.modules.management.gqlInputModel.GQLBuildingsInput;
import com.orhon.smartcampus.material.modules.management.inputMapper.BuildingsInputMapper;
import com.orhon.smartcampus.material.auth.JwtUtils;
import com.orhon.smartcampus.material.utils.QuerCount;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
public class AddBuildingsMutation implements DataFetcher {


    @Autowired
    BuildingsDao buildingsDao;

    @Autowired
    TokenService tokenService;

    /**
     * 楼层管理
     * editor : ths
     */
    @Override
    public Object get(DataFetchingEnvironment environment) throws Exception {

        String token = tokenService.getSystemToken();
        Long schoolId = JwtUtils.getSchoolId(token);
        Long userId = JwtUtils.getUserId(token);

        GQLBuildingsInput input = BuildingsInputMapper.MAPPER.mapInput(environment.getArgument("inputData"));

        Buildings buildings = null;

        if (input.getId() != null) {
            buildings = buildingsDao.get(Buildings.class, input.getId());
            buildings.setUpdated_at(new Date());
        } else {
            String hql = "SELECT buildings_name FROM Buildings where buildings_name = " + "'" + input.getBuildings_name() + "'";
            int size = buildingsDao.find(hql).size();
            if (size > 0){
                return Result.error("楼宇名称重复");
            }
            buildings = new Buildings();
            buildings.setCreated_at(new Date());
        }
        if(input.getBuildings_name() != null){
            buildings.setBuildings_name(input.getBuildings_name());
        }
        if(input.getSite_id() != null){
            buildings.setSite_id(input.getSite_id());
        }
        if(input.getBuildings_units() != null){
            buildings.setBuildings_units(input.getBuildings_units());
        }
        if(input.getBuildings_head() != null){
            buildings.setBuildings_head(input.getBuildings_head());
        }
        if(input.getBuildings_introduce()!= null){
            buildings.setBuildings_introduce(input.getBuildings_introduce());
        }
        if(input.getBuildings_status() != null){
            buildings.setBuildings_status(input.getBuildings_status());
        }
        buildings.setAdd_id(String.valueOf(userId));
        try {
            buildingsDao.saveOrUpdate(buildings);
        } catch (Exception e) {
            return Result.error(500, "" + e);
        }
        return Result.ok();
    }
}
