package com.orhon.smartcampus.material.modules.management.mm;

import com.orhon.smartcampus.material.basicComponents.ConvertHelper;
import com.orhon.smartcampus.material.modules.management.entity.GoodsClassify;
import com.orhon.smartcampus.material.modules.management.gqlModel.GQLGoodsClassify;
import org.mapstruct.InheritConfiguration;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

import java.util.List;

@Mapper(
        uses = {
           ConvertHelper.class
        }
)
public interface GoodsClassifyMapper {

    GoodsClassifyMapper MAPPER = Mappers.getMapper(GoodsClassifyMapper.class);


    @Mapping(source = "id" , target = "id")
    @Mapping(source = "classify_name" , target = "classify_name")
    @Mapping(source = "classify_status" , target = "classify_status")
    @Mapping(source = "add_id" , target = "add_id")
    @Mapping(source = "school_id" , target = "school_id")
    @Mapping(source = "created_at" , target = "created_at")
    @Mapping(source = "updated_at" , target = "updated_at")
    GQLGoodsClassify toGoodsClassify(GoodsClassify entity);

    @InheritConfiguration(name = "toGoodsClassify")
    List<GQLGoodsClassify> toGoodsClassifyList(List<GoodsClassify> entities);
}
