package com.orhon.smartcampus.material.modules.management.fetcher;

import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.base.gqlModel.GQLPageParam;
import com.orhon.smartcampus.material.modules.base.mm.EnvArgsMapper;
import com.orhon.smartcampus.material.modules.management.dao.UnitDao;
import com.orhon.smartcampus.material.modules.management.entity.Unit;
import com.orhon.smartcampus.material.modules.management.gqlModel.GQLUnit;
import com.orhon.smartcampus.material.modules.management.mm.UnitMapper;
import com.orhon.smartcampus.material.utils.ObjectToMap;
import com.orhon.smartcampus.material.utils.Util;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;

@Component
public class UnitListFetcher implements DataFetcher {

    @Autowired
    UnitDao unitDao;

    @Override
    public Object get(DataFetchingEnvironment env) throws Exception {

        // + schoolId
        String hql = "from Unit where 1=1 ";

        GQLPageParam page = EnvArgsMapper.MAPPER.fromArgs(env);

        if (env.containsArgument("condition")) {
            HashMap<String, Object> map = ObjectToMap.to(env.getArgument("condition"));
            if (map.get("id") != null) {
                hql += " and id " + Util.decide(map.get("id"));
            }
            if (map.get("unit_name") != null) {
                hql += " and unit_name " + Util.decide("like_" +map.get("unit_name"));
            }
            if (map.get("unit_status") != null) {
                hql += " and unit_status " + Util.decide(map.get("unit_status"));
            }
        }
        hql += " ORDER BY created_at DESC ";
        List<Unit> list = unitDao.find(hql, null, page.getPage(), page.getLimit());

        List<GQLUnit> gqlGoodsClassifies = UnitMapper.MAPPER.toUnitList(list);
        Long total = 0L;
        if (env.getSelectionSet().contains("total")) {
            total = unitDao.getTotalCount(hql);
        }
        return Result.ok().put("data", gqlGoodsClassifies).put("total", total);
    }
}
