package com.orhon.smartcampus.material.modules.management.fetcher;

import com.orhon.smartcampus.material.modules.management.dao.RoomDao;
import com.orhon.smartcampus.material.modules.management.dao.RootDao;
import com.orhon.smartcampus.material.modules.management.entity.RoomEntity;
import com.orhon.smartcampus.material.modules.management.entity.RootEntity;
import com.orhon.smartcampus.material.modules.management.gqlModel.GQLRootBeans;
import com.orhon.smartcampus.material.modules.management.gqlModel.RoomGqlModel;
import com.orhon.smartcampus.material.modules.management.mm.RoomMapper;
import com.orhon.smartcampus.material.modules.management.mm.RootBeanMapper;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SeleRoomOnceFetcher implements DataFetcher {
    @Autowired
    RoomDao roomDao;

    @Override
    public Object get(DataFetchingEnvironment environment) throws Exception {
        String hql = "from RoomEntity";
        RoomEntity item = roomDao.findId(hql, null);
        if(item!=null) {
            RoomGqlModel goodsClassify = RoomMapper.MAPPER.toRoomModel(item);
            return goodsClassify;
        }
        return null;
    }
}
