package com.orhon.smartcampus.material.modules.management.fetcher;

import com.orhon.smartcampus.material.modules.management.dao.FloorDao;
import com.orhon.smartcampus.material.modules.management.dao.RoomDao;
import com.orhon.smartcampus.material.modules.management.entity.FloorEntity;
import com.orhon.smartcampus.material.modules.management.entity.RoomEntity;
import com.orhon.smartcampus.material.modules.management.gqlModel.FloorGqlModel;
import com.orhon.smartcampus.material.modules.management.gqlModel.RoomGqlModel;
import com.orhon.smartcampus.material.modules.management.mm.FloorMapper;
import com.orhon.smartcampus.material.modules.management.mm.RoomMapper;
import com.sun.scenario.effect.Flood;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SeleFloorOnceFetcher implements DataFetcher {
    @Autowired
    FloorDao floorDao;

    @Override
    public Object get(DataFetchingEnvironment environment) throws Exception {
        String hql = "from RoomEntity";
        FloorEntity item = floorDao.findId(hql, null);
        if(item!=null) {
            FloorGqlModel floorGqlModel = FloorMapper.MAPPER.toFloorModel(item);
            return floorGqlModel;
        }
        return null;
    }
}
