package com.orhon.smartcampus.material.modules.management.fetcher;

import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.base.gqlModel.GQLPageParam;
import com.orhon.smartcampus.material.modules.base.mm.EnvArgsMapper;
import com.orhon.smartcampus.material.modules.management.dao.FloorDao;
import com.orhon.smartcampus.material.modules.management.dao.RoomDao;
import com.orhon.smartcampus.material.modules.management.entity.FloorEntity;
import com.orhon.smartcampus.material.modules.management.entity.RoomEntity;
import com.orhon.smartcampus.material.modules.management.gqlModel.FloorGqlModel;
import com.orhon.smartcampus.material.modules.management.gqlModel.RoomGqlModel;
import com.orhon.smartcampus.material.modules.management.mm.FloorMapper;
import com.orhon.smartcampus.material.modules.management.mm.RoomMapper;
import com.orhon.smartcampus.material.utils.ObjectToMap;
import com.orhon.smartcampus.material.utils.Util;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;

@Component
public class SeleFloorListFetcher implements DataFetcher {

    @Autowired
    FloorDao floorDao;

    @Override
    public Object get(DataFetchingEnvironment env) throws Exception {

        // + schoolId
        String hql = "from FloorEntity where 1=1 ";

        GQLPageParam page = EnvArgsMapper.MAPPER.fromArgs(env);

        if(env.containsArgument("condition")) {
            HashMap<String,Object> map = ObjectToMap.to(env.getArgument("condition"));
            if(map.get("id")!=null) {
                hql += " and id " + Util.decide(map.get("id"));
            }
            if(map.get("floor_name")!=null) {
                hql += " and floor_name " + Util.decide("like_" +map.get("floor_name"));
            }
            if(map.get("floor_status")!=null) {
                hql += " and floor_status " + Util.decide(map.get("floor_status"));
            }
        }
        hql += " ORDER BY created_at DESC ";
        List<FloorEntity> list = floorDao.find(hql,null,page.getPage(),page.getLimit());


        List<FloorGqlModel> gqlGoodsClassifies =  FloorMapper.MAPPER.toFloorList(list);
        Long total = 0L;
        if (env.getSelectionSet().contains("total")){
            total = floorDao.getTotalCount(hql);
        }
        return Result.ok().put("data", gqlGoodsClassifies).put("total", total);
    }
}
