package com.orhon.smartcampus.material.modules.management.fetcher;

import com.orhon.smartcampus.material.modules.management.dao.GoodsClassifyDao;
import com.orhon.smartcampus.material.modules.management.dao.RootDao;
import com.orhon.smartcampus.material.modules.management.entity.GoodsClassify;
import com.orhon.smartcampus.material.modules.management.entity.RootEntity;
import com.orhon.smartcampus.material.modules.management.gqlModel.GQLGoodsClassify;
import com.orhon.smartcampus.material.modules.management.gqlModel.GQLRootBeans;
import com.orhon.smartcampus.material.modules.management.mm.GoodsClassifyMapper;
import com.orhon.smartcampus.material.modules.management.mm.RootBeanMapper;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RootBeanFetcher implements DataFetcher {

    @Autowired
    RootDao rootDao;

    @Override
    public Object get(DataFetchingEnvironment env) throws Exception {

        // + schoolId
        String hql = "from RootEntity";
        RootEntity item =  rootDao.findId(hql, null);
        if(item!=null) {
            GQLRootBeans goodsClassify = RootBeanMapper.MAPPER.toRootsClassify(item);
            return goodsClassify;
        }
        return null;
    }
}
