package com.orhon.smartcampus.material.modules.management.fetcher;

import com.orhon.smartcampus.material.modules.management.mutation.*;
import graphql.schema.idl.RuntimeWiring;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MaterialFetchersLoader {

	@Autowired
	AddGoodsClassifyMutation addGoodsClassifyMutation;

	@Autowired
	GoodsClassifyListFetcher goodsClassifyListFetcher;

	@Autowired
	GoodsClassifyFetcher goodsClassifyFetcher;

	@Autowired
	GoodsManageListFetcher goodsManageListFetcher;

	@Autowired
	AddGoodsManageMutation addGoodsManageMutation;

	@Autowired
	BuildingsListFetcher buildingsListFetcher;

	@Autowired
	AddBuildingsMutation addBuildingsMutation;

	@Autowired
	AddRootSiteMutation addRootSiteMutation;

	@Autowired
	RootBeanFetcher rootBeanFetcher;

	@Autowired
	SiteListFetcher siteListFetcher;

	@Autowired
	AddRoomMutation addRoomMutation;

	@Autowired
	SeleRoomListFetcher seleRoomListFetcher;
	@Autowired
	SeleRoomOnceFetcher roomOnceFetcher;

	@Autowired
	AddFloorMutation addFloorMutation;

	@Autowired
	SeleFloorOnceFetcher seleFloorOnceFetcher;

	@Autowired
	SeleFloorListFetcher seleFloorListFetcher;

	@Autowired
	AddUnitMutation addUnitMutation;

	@Autowired
	UnitListFetcher unitListFetcher;


	public void LoadFetchers(RuntimeWiring.Builder builder){

		builder.type("Query" , t->t.dataFetcher("GoodsClassify" , goodsClassifyFetcher));
		builder.type("Query" , t->t.dataFetcher("GoodsClassifys" , goodsClassifyListFetcher));
		builder.type("Query" , t->t.dataFetcher("GoodsManages" , goodsManageListFetcher));
		builder.type("Query" , t->t.dataFetcher("BuildingsList" , buildingsListFetcher));
		builder.type("Query" , t->t.dataFetcher("SeleSite" , rootBeanFetcher));
		builder.type("Query" , t->t.dataFetcher("SeleSites" , siteListFetcher));
		builder.type("Query" , t->t.dataFetcher("SeleRoom" ,roomOnceFetcher ));
		builder.type("Query" , t->t.dataFetcher("SeleRooms" , seleRoomListFetcher));
		builder.type("Query" , t->t.dataFetcher("SeleFloor" , seleFloorOnceFetcher));
		builder.type("Query" , t->t.dataFetcher("SeleFloors" , seleFloorListFetcher));
		builder.type("Query" , t->t.dataFetcher("UnitList" , unitListFetcher));


		builder.type("Mutation" , t->t.dataFetcher("addMaterialRoomAdds" , addRoomMutation));
		builder.type("Mutation" , t->t.dataFetcher("addMaterialSiteAdds" , addRootSiteMutation));
		builder.type("Mutation" , t->t.dataFetcher("addGoodsClassify" , addGoodsClassifyMutation));
		builder.type("Mutation" , t->t.dataFetcher("addMaterialFloorAdds" , addFloorMutation));
		builder.type("Mutation" , t->t.dataFetcher("addGoodsClassify" , addGoodsClassifyMutation));
		builder.type("Mutation" , t->t.dataFetcher("addGoodsManage" , addGoodsManageMutation));
		builder.type("Mutation" , t->t.dataFetcher("addBuildings" , addBuildingsMutation));
		builder.type("Mutation" , t->t.dataFetcher("addUnit" , addUnitMutation));
	}


}
