package com.orhon.smartcampus.material.modules.management.fetcher;

import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.base.gqlModel.GQLPageParam;
import com.orhon.smartcampus.material.modules.base.mm.EnvArgsMapper;
import com.orhon.smartcampus.material.modules.management.dao.GoodsClassifyDao;
import com.orhon.smartcampus.material.modules.management.entity.GoodsClassify;
import com.orhon.smartcampus.material.modules.management.gqlModel.GQLGoodsClassify;
import com.orhon.smartcampus.material.modules.management.mm.GoodsClassifyMapper;
import com.orhon.smartcampus.material.utils.ObjectToMap;
import com.orhon.smartcampus.material.utils.Util;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Component
public class GoodsClassifyListFetcher implements DataFetcher {

    @Autowired
    GoodsClassifyDao goodsClassifyDao;

    @Override
    public Object get(DataFetchingEnvironment env) throws Exception {

        // + schoolId
        String hql = "from GoodsClassify where 1=1 ";

        GQLPageParam page = EnvArgsMapper.MAPPER.fromArgs(env);

        if(env.containsArgument("condition")) {
            HashMap<String,Object> map = ObjectToMap.to(env.getArgument("condition"));
            if(map.get("id")!=null) {
                hql += " and id " + Util.decide(map.get("id"));
            }
            if(map.get("classify_name")!=null) {
                hql += " and classify_name " +  Util.decide("like_" + map.get("classify_name"));
            }
            if(map.get("classify_status")!=null) {
                hql += " and  classify_status  " + Util.decide(map.get("classify_status"));
            }
        }
        hql += " ORDER BY created_at DESC ";
        List<GoodsClassify> list = goodsClassifyDao.find(hql,null,page.getPage(),page.getLimit());

        List<GQLGoodsClassify> gqlGoodsClassifies =  GoodsClassifyMapper.MAPPER.toGoodsClassifyList(list);
        Long total = 0L;
        if (env.getSelectionSet().contains("total")){
            total = goodsClassifyDao.getTotalCount(hql);
        }
        return Result.ok().put("data", gqlGoodsClassifies).put("total", total);
    }
}
