package com.orhon.smartcampus.material.modules.management.fetcher;

import com.orhon.smartcampus.material.basicComponents.Result;
import com.orhon.smartcampus.material.modules.base.gqlModel.GQLPageParam;
import com.orhon.smartcampus.material.modules.base.mm.EnvArgsMapper;
import com.orhon.smartcampus.material.modules.management.dao.GoodsClassifyDao;
import com.orhon.smartcampus.material.modules.management.entity.GoodsClassify;
import com.orhon.smartcampus.material.modules.management.gqlModel.GQLGoodsClassify;
import com.orhon.smartcampus.material.modules.management.mm.GoodsClassifyMapper;
import com.orhon.smartcampus.material.utils.ObjectToMap;
import com.orhon.smartcampus.material.utils.Util;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Component
public class GoodsClassifyFetcher implements DataFetcher {

    @Autowired
    GoodsClassifyDao goodsClassifyDao;

    @Override
    public Object get(DataFetchingEnvironment env) throws Exception {

        // + schoolId
        String hql = "from GoodsClassify";
        GoodsClassify item =  goodsClassifyDao.findId(hql, null);
        if(item!=null) {
            GQLGoodsClassify goodsClassify = GoodsClassifyMapper.MAPPER.toGoodsClassify(item);
            return goodsClassify;
        }
        return null;
    }
}
