package com.orhon.smartcampus.material.cloud;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;


@Component
public class Api {

    @Autowired
    private RestTemplate restTemplate;


    public ResponseEntity<Map> buildGqlQuery(String query){
        Map<String , Object> data = new HashMap<>();
        data.put("query" , query);
        data.put("operationName" , null);
        data.put("variables" , null);
        String payload = JSON.toJSONString(data , SerializerFeature.WriteMapNullValue);
        HttpHeaders headers = new HttpHeaders();
        String graphqlMapping = "http://smartcampus-base/graphql";
        HttpEntity<Object> request = this.forJson(payload , headers);
        return restTemplate.exchange(graphqlMapping, HttpMethod.POST, request, Map.class);
    }


    private HttpEntity<Object> forJson(String json, HttpHeaders headers) {
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        return new HttpEntity<>(json, headers);
    }

}



