package com.orhon.smartcampus.material.basicComponents;


import com.alibaba.fastjson.JSON;
import com.google.common.base.Optional;
import lombok.Data;

import java.util.Map;

@Data
public class GQLLang {

    private String zh;
    private String en;
    private String mn;

    public GQLLang(){

    }


    public static String getZhs(String jsonStr){
        Map<String,String> jLang = (Map) JSON.parse(jsonStr);
        String ret = "";
        try{
            ret = jLang.get("zh");
        }
        catch (Exception e){
            ret = "";
        }
        return ret;
    }

    public static String getEns(String jsonStr){
        Map<String,String> jLang = (Map) JSON.parse(jsonStr);
        String ret = "";
        try{
            ret = jLang.get("en");
        }
        catch (Exception e){
            ret = "";
        }
        return ret;
    }

    public static String getMns(String jsonStr){
        Map<String,String> jLang = (Map) JSON.parse(jsonStr);
        String ret = "";
        try{
            ret = jLang.get("mn");
        }
        catch (Exception e){
            ret = "";
        }
        return ret;
    }


    public GQLLang(String jsonStr){
        Map<String,String> jLang = (Map) JSON.parse(jsonStr);
        try {
            Optional<String> m_ZH = Optional.fromNullable(jLang.get("zh"));
            Optional<String> m_EN = Optional.fromNullable(jLang.get("en"));
            Optional<String> m_MN = Optional.fromNullable(jLang.get("mn"));
            this.zh = m_ZH.or("");
            this.en = m_EN.or("");
            this.mn = m_MN.or("");
        }
        catch (Exception e){
            this.zh = "";
            this.en = "";
            this.mn = "";
        }
    }



}
