package com.orhon.smartcampus.material.basicComponents;


import org.mapstruct.Mapper;
import org.mapstruct.Qualifier;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;

@Mapper
public interface ConvertHelper {

    //id安全转换器

    @Qualifier
    @Target(ElementType.METHOD)
    @Retention(RetentionPolicy.SOURCE)
    public @interface Id {
    }

    @Id
    default public Long id(Map<String, Object> in) {
        Long ret = null;
        try{
            ret = Long.valueOf(String.valueOf(in.get("id"))).longValue();
        }
        catch (Exception e) {}
        return ret;
    }



}
