package com.orhon.smartcampus.material.auth;

import static com.auth0.jwt.JWT.create;
import static com.auth0.jwt.JWT.decode;
import static com.auth0.jwt.JWT.require;

import java.util.Date;

import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;

public class JwtUtils {

    private static final long EXPIRE_TIME = 5 * 60 * 1000;

    /**
     * 校验token是否正确
     *
     * @param token  密钥
     * @param secret 用户的密码
     * @return 是否正确
     */
    public static boolean verify(String token, String username, String secret) {
        try {
            //根据密码生成JWT效验器
            Algorithm algorithm = Algorithm.HMAC256(secret);
            JWTVerifier verifier = require(algorithm)
                    .withClaim("username", username)
                    .build();
            //效验TOKEN
            DecodedJWT jwt = verifier.verify(token);
            return true;
        } catch (Exception exception) {
            return false;
        }
    }

    /**
     * 获得token中的信息无需secret解密也能获得
     *
     * @return token中包含的用户名
     */
    public static String getUsername(String token) {
        try {
            DecodedJWT jwt = decode(token);
            return jwt.getClaim("username").asString();
        } catch (JWTDecodeException e) {
            return null;
        }
    }

    public static Long getUserId(String token){
        try{
            DecodedJWT jwt = decode(token);
            return jwt.getClaim("userid").asLong();
        }catch (JWTDecodeException e){
            return null;
        }
    }
    public static String getUserType(String token){
        try{
            DecodedJWT jwt = decode(token);
            return jwt.getClaim("user_type").asString();
        }catch (JWTDecodeException e){
            return null;
        }
    }


    public static Long getSchoolId(String token){
        try{
            //token = token==null?"eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzY2hvb2xfaWQiOjEsImV4cCI6MTU2ODkzMDYyMSwidXNlcmlkIjoxLCJ1c2VybmFtZSI6InRlYWNoZXIifQ.Rh2NncYkPkSaN1BImRwgQGPtbz2Pwb0EviUQTXtfykQ":token;
            DecodedJWT jwt = decode(token);
            return jwt.getClaim("school_id").asLong();
        }catch (JWTDecodeException e){
            return null;
        }
    }

    /**
     * 生成签名,5min后过期
     *
     * @param username 用户名
     * @param secret   用户的密码
     * @return 加密的token
     */
    public static String sign(String username, String secret) {
        Date date = new Date(System.currentTimeMillis() + EXPIRE_TIME);
        Algorithm algorithm = Algorithm.HMAC256(secret);
        // 附带username信息
        return create()
                .withClaim("username", username)
                .withExpiresAt(date)
                .sign(algorithm);

    }

    //sign的重载函数
    public static String sign(String username, String secret , Date expireTime) {
        Date date = expireTime;
        Algorithm algorithm = Algorithm.HMAC256(secret);
        // 附带username信息
        return create()
                .withClaim("username", username)
                .withExpiresAt(date)
                .sign(algorithm);
    }


    //sign的重载函数
    public static String sign(String username, Long userId ,  Long schoolId , String secret , Date expireTime) {
        Date date = expireTime;
        Algorithm algorithm = Algorithm.HMAC256(secret);
        // 附带username信息
        return create()
                .withClaim("username", username)
                .withClaim("userid" , userId)
                .withClaim("school_id" , schoolId)
                .withExpiresAt(date)
                .sign(algorithm);
    }
    //sign的重载函数
    public static String sign(String username, Long userId ,  Long schoolId , String secret , Date expireTime, String userType) {
        Date date = expireTime;
        Algorithm algorithm = Algorithm.HMAC256(secret);
        // 附带username信息
        return create()
                .withClaim("username", username)
                .withClaim("userid" , userId)
                .withClaim("school_id" , schoolId)
                .withClaim("user_type" , userType)
                .withExpiresAt(date)
                .sign(algorithm);
    }





}
