import os
from setuptools import setup
from setuptools import find_packages

README = open(os.path.join(os.path.dirname(__file__), 'README.rst')).read()
REQUIREMENTS = [line.strip() for line in
                open("requirements.txt").readlines()]

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup(
    name='event-tracking',
    version='0.2.2',
    packages=find_packages(),
    include_package_data=True,
    license='AGPLv3 License',
    description='A simple event tracking system.',
    long_description=README,
    install_requires=[
        'Django >= 1.8, < 1.9',
        'pymongo',
        'pytz',
    ],
    url='http://code.edx.org/',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: GNU Affero General Public License v3 (GPLv3)'
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
    ],
)
