# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2017-10-16 12:11
from __future__ import unicode_literals

import VEDA_OS01.models
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('VEDA_OS01', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='TranscriptCredentials',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('org', models.CharField(help_text=b'This value must match the value of organization in studio/edx-platform.', max_length=50, verbose_name=b'Organization')),
                ('provider', models.CharField(choices=[(b'3PlayMedia', b'3PlayMedia'), (b'Cielo24', b'Cielo24')], max_length=50, verbose_name=b'Transcript provider')),
                ('api_key', models.CharField(max_length=255, verbose_name=b'API key')),
                ('api_secret', models.CharField(blank=True, max_length=255, null=True, verbose_name=b'API secret')),
            ],
            options={
                'verbose_name_plural': 'Transcript Credentials',
            },
        ),
        migrations.CreateModel(
            name='TranscriptProcessMetadata',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('provider', models.CharField(choices=[(b'3PlayMedia', b'3PlayMedia'), (b'Cielo24', b'Cielo24')], max_length=50, verbose_name=b'Transcript provider')),
                ('process_id', models.CharField(max_length=255, verbose_name=b'Process id')),
                ('translation_id', models.CharField(blank=True, help_text=b'Keeps track of 3Play Translations', max_length=255, null=True, verbose_name=b'Translation id')),
                ('lang_code', models.CharField(max_length=50, verbose_name=b'Language code')),
                ('status', models.CharField(choices=[(b'N/A', b'N/A'), (b'PENDING', b'PENDING'), (b'IN PROGRESS', b'IN PROGRESS'), (b'FAILED', b'FAILED'), (b'READY', b'READY')], default=b'PENDING', max_length=50, verbose_name=b'Transcript status')),
            ],
            options={
                'get_latest_by': 'modified',
                'verbose_name_plural': 'Transcript process metadata',
            },
        ),
        migrations.AddField(
            model_name='video',
            name='cielo24_fidelity',
            field=models.CharField(blank=True, choices=[(b'MECHANICAL', b'Mechanical, 75% Accuracy'), (b'PREMIUM', b'Premium, 95% Accuracy'), (b'PROFESSIONAL', b'Professional, 99% Accuracy')], max_length=20, null=True, verbose_name=b'Cielo24 Fidelity'),
        ),
        migrations.AddField(
            model_name='video',
            name='cielo24_turnaround',
            field=models.CharField(blank=True, choices=[(b'STANDARD', b'Standard, 48h'), (b'PRIORITY', b'Priority, 24h')], max_length=20, null=True, verbose_name=b'Cielo24 Turnaround'),
        ),
        migrations.AddField(
            model_name='video',
            name='preferred_languages',
            field=VEDA_OS01.models.ListField(blank=True, default=[]),
        ),
        migrations.AddField(
            model_name='video',
            name='process_transcription',
            field=models.BooleanField(default=False, verbose_name=b'Process transcripts from Cielo24/3PlayMedia'),
        ),
        migrations.AddField(
            model_name='video',
            name='provider',
            field=models.CharField(blank=True, choices=[(b'3PlayMedia', b'3PlayMedia'), (b'Cielo24', b'Cielo24')], max_length=20, null=True, verbose_name=b'Transcription provider'),
        ),
        migrations.AddField(
            model_name='video',
            name='source_language',
            field=models.CharField(blank=True, help_text=b'This is video speech language.', max_length=50, null=True, verbose_name=b'video source language'),
        ),
        migrations.AddField(
            model_name='video',
            name='three_play_turnaround',
            field=models.CharField(blank=True, choices=[(b'extended_service', b'10-Day/Extended'), (b'default', b'4-Day/Default'), (b'expedited_service', b'2-Day/Expedited'), (b'rush_service', b'24 hour/Rush'), (b'same_day_service', b'Same Day')], max_length=20, null=True, verbose_name=b'3PlayMedia Turnaround'),
        ),
        migrations.AddField(
            model_name='video',
            name='transcript_status',
            field=models.CharField(choices=[(b'N/A', b'N/A'), (b'PENDING', b'PENDING'), (b'IN PROGRESS', b'IN PROGRESS'), (b'FAILED', b'FAILED'), (b'READY', b'READY')], default=b'N/A', max_length=100, verbose_name=b'Transcription Status'),
        ),
        migrations.AddField(
            model_name='transcriptprocessmetadata',
            name='video',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='transcript_processes', to='VEDA_OS01.Video'),
        ),
        migrations.AlterUniqueTogether(
            name='transcriptcredentials',
            unique_together=set([('org', 'provider')]),
        ),
    ]
