# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2017-08-14 15:05
from __future__ import unicode_literals

import VEDA_OS01.models
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Course',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('course_name', models.CharField(max_length=100, verbose_name=b'Course Name')),
                ('course_hold', models.BooleanField(default=False, verbose_name=b'Course Active')),
                ('institution', models.CharField(max_length=4, verbose_name=b'Inst. Code')),
                ('edx_classid', models.CharField(max_length=5, verbose_name=b'Class ID')),
                ('semesterid', models.CharField(max_length=4, verbose_name=b'Semester')),
                ('parent_ID', models.CharField(blank=True, max_length=8, null=True, verbose_name=b'Parent Project')),
                ('previous_statechange', models.DateTimeField(blank=True, null=True, verbose_name=b'Previous Data Statechange')),
                ('proc_loc', models.BooleanField(default=False, verbose_name=b'Mediateam Export')),
                ('review_proc', models.BooleanField(default=False, verbose_name=b'Producer Review')),
                ('last_vid_number', models.IntegerField(default=0, verbose_name=b'Last Video ID')),
                ('yt_proc', models.BooleanField(default=True, verbose_name=b'Process for Youtube')),
                ('yt_logon', models.CharField(blank=True, max_length=50, null=True, verbose_name=b'Youtube SFTP U/N')),
                ('yt_channel', models.CharField(blank=True, max_length=150, null=True, verbose_name=b'Youtube Channel ID')),
                ('tp_proc', models.BooleanField(default=False, verbose_name=b'Process for 3Play')),
                ('tp_username', models.CharField(blank=True, max_length=50, null=True, verbose_name=b'3Play Username')),
                ('tp_password', models.CharField(blank=True, max_length=50, null=True, verbose_name=b'3Play Password')),
                ('tp_speed', models.CharField(choices=[(b'extended_service', b'10-Day/Extended'), (b'default', b'4-Day/Default'), (b'expedited_service', b'2-Day/Expedited'), (b'rush_service', b'24 hour/Rush'), (b'same_day_service', b'Same Day')], default=b'default', max_length=20, verbose_name=b'3Play Turnaround')),
                ('tp_apikey', models.CharField(blank=True, max_length=100, null=True, verbose_name=b'3Play API Key')),
                ('c24_proc', models.BooleanField(default=False, verbose_name=b'Process for Cielo24')),
                ('c24_username', models.CharField(blank=True, max_length=50, null=True, verbose_name=b'Cielo24 Username')),
                ('c24_password', models.CharField(blank=True, max_length=50, null=True, verbose_name=b'Cielo24Password')),
                ('c24_speed', models.CharField(choices=[(b'STANDARD', b'Standard, 48h'), (b'PRIORITY', b'Priority, 24h')], default=b'STANDARD', max_length=20, verbose_name=b'Cielo24 Turnaround')),
                ('c24_fidelity', models.CharField(choices=[(b'MECHANICAL', b'Mechanical, 75%'), (b'PREMIUM', b'Premium, 95%'), (b'PROFESSIONAL', b'Professional, 99%')], default=b'PROFESSIONAL', max_length=20, verbose_name=b'Cielo24 Fidelity')),
                ('c24_hours', models.IntegerField(blank=True, null=True, verbose_name=b'C24 Turnaround Override')),
                ('c24_apikey', models.CharField(blank=True, max_length=100, null=True, verbose_name=b'Cielo24 API Key')),
                ('s3_proc', models.BooleanField(default=True, verbose_name=b'Process for AWS S3/Mobile?')),
                ('mobile_override', models.BooleanField(default=False, verbose_name=b'Low Bandwidth Override')),
                ('s3_dir', models.CharField(blank=True, max_length=50, null=True, verbose_name=b'S3 Directory')),
                ('xue', models.BooleanField(default=False, verbose_name=b'Submit to VAL')),
                ('local_storedir', models.CharField(blank=True, max_length=5000, null=True, verbose_name=b'edX Studio URL (VAL)')),
                ('xuetang_proc', models.BooleanField(default=True, verbose_name=b'Submit to XuetangX')),
                ('sg_projID', models.IntegerField(default=0, verbose_name=b'Shotgun Project ID')),
                ('studio_hex', models.CharField(default=VEDA_OS01.models._createHex, max_length=50, unique=True, verbose_name=b'Studio Hex ID')),
            ],
        ),
        migrations.CreateModel(
            name='Destination',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('destination_name', models.CharField(blank=True, max_length=200, null=True, verbose_name=b'Destination')),
                ('destination_active', models.BooleanField(default=False, verbose_name=b'Destination Active')),
                ('destination_nick', models.CharField(blank=True, max_length=3, null=True, verbose_name=b'Nickname (3 Char.)')),
            ],
        ),
        migrations.CreateModel(
            name='Encode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('encode_name', models.CharField(blank=True, max_length=100, null=True, verbose_name=b'Encode Name')),
                ('profile_active', models.BooleanField(default=False, verbose_name=b'Encode Profile Active')),
                ('encode_suffix', models.CharField(blank=True, max_length=10, null=True, verbose_name=b'Encode Suffix (No underscore)')),
                ('encode_filetype', models.CharField(choices=[(b'mp4', b'mpeg-4'), (b'srt', b'srt file'), (b'webm', b'webm'), (b'mp3', b'mp3'), (b'HLS', b'HLS')], default=b'mp4', max_length=50, verbose_name=b'Encode Filetype')),
                ('encode_bitdepth', models.CharField(blank=True, max_length=50, null=True, verbose_name=b'Target Bit Depth / Rate Factor')),
                ('encode_resolution', models.CharField(blank=True, max_length=50, null=True, verbose_name=b'Target Resolution (Vert)')),
                ('product_spec', models.CharField(blank=True, max_length=300, null=True, verbose_name=b'VAL Profile Name')),
                ('xuetang_proc', models.BooleanField(default=False, verbose_name=b'Submit to XuetangX')),
                ('encode_destination', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='VEDA_OS01.Destination')),
            ],
        ),
        migrations.CreateModel(
            name='Institution',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('institution_code', models.CharField(max_length=4)),
                ('institution_name', models.CharField(max_length=50)),
            ],
        ),
        migrations.CreateModel(
            name='URL',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('encode_url', models.CharField(blank=True, max_length=500, null=True, verbose_name=b'Destination URL')),
                ('url_date', models.DateTimeField(blank=True, null=True, verbose_name=b'URL Updated')),
                ('encode_duration', models.CharField(blank=True, max_length=50, null=True, verbose_name=b'Duration (sec)')),
                ('encode_bitdepth', models.CharField(blank=True, max_length=50, null=True, verbose_name=b'Encoded Avg. Bitdepth')),
                ('encode_size', models.IntegerField(blank=True, default=b'0', null=True, verbose_name=b'File Size (bytes)')),
                ('val_input', models.BooleanField(default=False, verbose_name=b'Inputted to EDX-VAL?')),
                ('xuetang_input', models.BooleanField(default=False, verbose_name=b'Inputted to XuetangX?')),
                ('md5_sum', models.CharField(blank=True, max_length=100, null=True, verbose_name=b'MD5 Sum')),
                ('encode_profile', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='VEDA_OS01.Encode')),
            ],
            options={
                'get_latest_by': 'url_date',
            },
        ),
        migrations.CreateModel(
            name='VedaUpload',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('video_serial', models.CharField(max_length=20, verbose_name=b'Upload Process Serial')),
                ('edx_studio_url', models.CharField(blank=True, max_length=500, null=True, verbose_name=b'edX Studio URL (VAL)')),
                ('client_information', models.CharField(blank=True, max_length=500, null=True, verbose_name=b'Client Information Field')),
                ('status_email', models.CharField(blank=True, max_length=100, null=True, verbose_name=b'Status Target Email')),
                ('upload_filename', models.CharField(blank=True, max_length=180, null=True, verbose_name=b'Video (Client) Title')),
                ('upload_date', models.DateTimeField(blank=True, null=True, verbose_name=b'Upload Datetime')),
                ('edx_id', models.CharField(max_length=20, verbose_name=b'VEDA Video ID')),
                ('file_valid', models.BooleanField(default=False, verbose_name=b'Valid')),
                ('final_report', models.BooleanField(default=False, verbose_name=b'Reported')),
                ('file_complete', models.BooleanField(default=False, verbose_name=b'Complete')),
                ('youtube_id', models.CharField(blank=True, max_length=100, null=True, verbose_name=b'Youtube ID')),
                ('comment', models.CharField(blank=True, max_length=500, null=True, verbose_name=b'Comment/Info')),
            ],
            options={
                'get_latest_by': 'upload_date',
            },
        ),
        migrations.CreateModel(
            name='Video',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('video_active', models.BooleanField(default=True, verbose_name=b'Video Active?')),
                ('client_title', models.CharField(blank=True, max_length=180, null=True, verbose_name=b'Video (Client) Title')),
                ('edx_id', models.CharField(max_length=20, verbose_name=b'VEDA Video ID')),
                ('studio_id', models.CharField(blank=True, max_length=100, null=True, verbose_name=b'Studio Upload ID')),
                ('video_orig_filesize', models.BigIntegerField(blank=True, null=True, verbose_name=b'Master Filesize')),
                ('video_orig_duration', models.CharField(blank=True, max_length=50, null=True, verbose_name=b'Duration (Original)')),
                ('video_orig_bitrate', models.CharField(blank=True, max_length=15, null=True, verbose_name=b'Orig. Bitrate')),
                ('video_orig_extension', models.CharField(blank=True, max_length=5, null=True, verbose_name=b'Orig. File Extension')),
                ('video_orig_resolution', models.CharField(blank=True, max_length=50, null=True, verbose_name=b'Orig. Resolution')),
                ('video_trans_start', models.DateTimeField(blank=True, null=True, verbose_name=b'Process Start')),
                ('video_trans_end', models.DateTimeField(blank=True, null=True, verbose_name=b'Process Complete')),
                ('video_trans_status', models.CharField(choices=[(b'Ingest', b'System Ingest'), (b'Transcode Queue', b'Transcode Queue'), (b'Active Transcode', b'Active Transcode'), (b'Transcode Retry', b'Transcode Retry'), (b'Transcode Complete', b'Transcode Complete'), (b'Deliverable Upload', b'Deliverable Upload'), (b'File Complete', b'File Complete'), (b'Transcode Error', b'Transcode Error'), (b'Corrupt File', b'Corrupt File on Ingest'), (b'Review Hold', b'Review Hold'), (b'Review Reject', b'Review Rejected'), (b'Final Publish', b'Review to Final Publish'), (b'Youtube Duplicate', b'Youtube Duplicate'), (b'Queue', b'In Encode Queue'), (b'Progress', b'In Progress'), (b'Complete', b'Complete')], default=b'Ingest', max_length=100, verbose_name=b'Transcode Status')),
                ('video_glacierid', models.CharField(blank=True, max_length=200, null=True, verbose_name=b'Glacier Archive ID String')),
                ('abvid_serial', models.CharField(blank=True, max_length=20, null=True, verbose_name=b'VEDA Upload Process Serial')),
                ('stat_queuetime', models.FloatField(default=0, verbose_name=b'Video Avg. Queuetime (sec)')),
                ('inst_class', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='VEDA_OS01.Course')),
            ],
            options={
                'get_latest_by': 'video_trans_start',
            },
        ),
        migrations.AddField(
            model_name='url',
            name='videoID',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='VEDA_OS01.Video'),
        ),
    ]
