/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import protex.AminoAcid;
import protex.Attributes;
import protex.FoldedPolypeptide;
import protex.FoldingException;
import protex.FoldingManager;
import protex.OutputPalette;
import protex.Polypeptide;
import protex.ProteinImageFactory;
import protex.ProteinImageSet;
import protex.Protex;
import protex.StandardTable;
import protex.TripleLetterCodeDocument;

public class FoldingWindow
extends JPanel {
    final Protex protex;
    JPanel proteinPanel;
    JTextField proteinSequence;
    TripleLetterCodeDocument tlcDoc;
    OutputPalette outputPalette;
    JPanel buttonPanel;
    JButton foldButton;
    JComboBox ssBondChoice;
    boolean ssBondsOn;
    Polypeptide polypeptide;
    Attributes attributes;
    FoldingManager manager;
    JScrollPane proteinScrollPane;
    StandardTable table;
    FoldedPolypeptide foldedPolypeptide;
    BufferedImage fullSizePic;
    private static final int thumbWidth = 130;
    private static final int thumbHeight = 70;

    public FoldingWindow(String title, Protex protex) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(title));
        this.setBackground(Color.lightGray);
        this.protex = protex;
        this.foldedPolypeptide = null;
        this.fullSizePic = null;
        this.proteinPanel = new JPanel();
        this.proteinPanel.setLayout(new BorderLayout());
        this.tlcDoc = new TripleLetterCodeDocument();
        this.proteinSequence = new JTextField(50);
        this.proteinSequence.setBorder(BorderFactory.createTitledBorder("Amino Acid Sequence"));
        this.proteinSequence.setDocument(this.tlcDoc);
        this.proteinSequence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (FoldingWindow.this.foldButton.isEnabled()) {
                    FoldingWindow.this.foldProtein();
                }
            }
        });
        this.outputPalette = new OutputPalette();
        this.proteinScrollPane = new JScrollPane(this.outputPalette);
        this.proteinPanel.add((Component)this.proteinSequence, "North");
        this.proteinPanel.add((Component)this.proteinScrollPane, "Center");
        this.tlcDoc.setLinkedFoldingWindow(this);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.foldButton = new JButton("FOLD");
        this.foldButton.setEnabled(false);
        this.buttonPanel.add(this.foldButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
        String[] ssChoices = new String[]{"Disulfide Bonds OFF", "Disulfide Bonds ON"};
        this.ssBondChoice = new JComboBox<String>(ssChoices);
        this.buttonPanel.add(this.ssBondChoice);
        this.ssBondsOn = false;
        this.add((Component)this.proteinPanel, "Center");
        this.add((Component)this.buttonPanel, "South");
        this.manager = FoldingManager.getInstance();
        this.table = StandardTable.getInstance();
        this.foldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FoldingWindow.this.foldProtein();
            }
        });
        this.ssBondChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FoldingWindow.this.aaSeqChanged();
            }
        });
    }

    private void foldProtein() {
        String ssBondIndex = "";
        if (this.ssBondChoice.getSelectedIndex() == 0) {
            this.ssBondsOn = false;
            ssBondIndex = "0.0";
        } else {
            this.ssBondsOn = true;
            ssBondIndex = "1.5";
        }
        boolean customEnergy = false;
        if (this.protex.custom != null && this.protex.custom.isSelected()) {
            customEnergy = true;
        }
        this.attributes = new Attributes(this.proteinSequence.getText().trim(), customEnergy, 3, ssBondIndex, "straight", "test");
        try {
            this.manager.fold(this.attributes);
        }
        catch (FoldingException e) {
            e.printStackTrace();
        }
        this.manager.createCanvas(this.outputPalette);
        Dimension requiredCanvasSize = this.outputPalette.getDrawingPane().getRequiredCanvasSize();
        this.outputPalette.setssBondsOn(this.ssBondsOn);
        this.outputPalette.repaint();
        ProteinImageSet images = ProteinImageFactory.generateImages(this.outputPalette);
        this.foldedPolypeptide = new FoldedPolypeptide(this.ssBondsOn, this.proteinSequence.getText().trim(), this.outputPalette.getDrawingPane().getGrid(), new ImageIcon(images.getFullScaleImage()), new ImageIcon(images.getThumbnailImage()));
        this.protex.addFoldedToHistList(this.foldedPolypeptide);
        this.foldButton.setEnabled(false);
        this.outputPalette.setBackground(Color.lightGray);
    }

    public String getAaSeq() {
        return this.proteinSequence.getText();
    }

    public FoldedPolypeptide getFoldedPolypeptide() {
        return this.foldedPolypeptide;
    }

    public OutputPalette getOutputPalette() {
        return this.outputPalette;
    }

    public BufferedImage getFullSizePic() {
        return this.fullSizePic;
    }

    public void aaSeqChanged() {
        this.foldButton.setEnabled(true);
        this.outputPalette.setBackground(Color.PINK);
    }

    public void setFoldedPolypeptide(FoldedPolypeptide fp) {
        this.foldedPolypeptide = fp;
        String aaSeq = fp.getAaSeq();
        StringBuffer abAASeq = new StringBuffer();
        StringTokenizer st = new StringTokenizer(aaSeq);
        while (st.hasMoreTokens()) {
            AminoAcid aa = this.table.get(st.nextToken());
            abAASeq.append(aa.getAbName());
        }
        ((TripleLetterCodeDocument)this.proteinSequence.getDocument()).removeAll();
        this.proteinSequence.setText(abAASeq.toString());
        this.outputPalette.getDrawingPane().setGrid(fp.getFullSizeGrid());
        this.outputPalette.getDrawingPane().repaint();
        this.outputPalette.getDrawingPane().revalidate();
        Dimension requiredCanvasSize = this.outputPalette.getDrawingPane().getRequiredCanvasSize();
        this.fullSizePic = new BufferedImage(requiredCanvasSize.width, requiredCanvasSize.height, 1);
        Graphics2D g = this.fullSizePic.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.outputPalette.getDrawingPane().paint(g);
        g.dispose();
        this.ssBondsOn = fp.getssBondsOn();
        this.outputPalette.setssBondsOn(fp.getssBondsOn());
        if (this.ssBondsOn) {
            this.ssBondChoice.setSelectedIndex(1);
        } else {
            this.ssBondChoice.setSelectedIndex(0);
        }
        this.outputPalette.setBackground(Color.LIGHT_GRAY);
        this.foldButton.setEnabled(false);
    }
}

