from xmodule.modulestore.xml_importer import import_from_xml

from xmodule.modulestore.tests.django_utils import ModuleStoreTestCase
from xmodule.modulestore.django import modulestore


# This test is in the CMS module because the test configuration to use a draft
# modulestore is dependent on django.
class DraftReorderTestCase(ModuleStoreTestCase):

    def test_order(self):
        store = modulestore()
        _, course_items = import_from_xml(store, self.user.id, 'common/test/data/', ['import_draft_order'])
        course_key = course_items[0].id
        sequential = store.get_item(course_key.make_usage_key('sequential', '0f4f7649b10141b0bdc9922dcf94515a'))
        verticals = sequential.children

        # The order that files are read in from the file system is not guaranteed (cannot rely on
        # alphabetical ordering, for example). Therefore, I have added a lot of variation in filename and desired
        # ordering so that the test reliably failed with the bug, at least on Linux.
        #
        # 'a', 'b', 'c', 'd', and 'z' are all drafts, with 'index_in_children_list' of
        #  2 ,  4 ,  6 ,  5 , and  0  respectively.
        #
        # '5a05be9d59fc4bb79282c94c9e6b88c7' and 'second' are public verticals.
        self.assertEqual(7, len(verticals))
        self.assertEqual(course_key.make_usage_key('vertical', 'z'), verticals[0])
        self.assertEqual(course_key.make_usage_key('vertical', '5a05be9d59fc4bb79282c94c9e6b88c7'), verticals[1])
        self.assertEqual(course_key.make_usage_key('vertical', 'a'), verticals[2])
        self.assertEqual(course_key.make_usage_key('vertical', 'second'), verticals[3])
        self.assertEqual(course_key.make_usage_key('vertical', 'b'), verticals[4])
        self.assertEqual(course_key.make_usage_key('vertical', 'd'), verticals[5])
        self.assertEqual(course_key.make_usage_key('vertical', 'c'), verticals[6])

        # Now also test that the verticals in a second sequential are correct.
        sequential = store.get_item(course_key.make_usage_key('sequential', 'secondseq'))
        verticals = sequential.children
        # 'asecond' and 'zsecond' are drafts with 'index_in_children_list' 0 and 2, respectively.
        # 'secondsubsection' is a public vertical.
        self.assertEqual(3, len(verticals))
        self.assertEqual(course_key.make_usage_key('vertical', 'asecond'), verticals[0])
        self.assertEqual(course_key.make_usage_key('vertical', 'secondsubsection'), verticals[1])
        self.assertEqual(course_key.make_usage_key('vertical', 'zsecond'), verticals[2])
