# -*- coding: utf-8 -*-
"""
End-to-end tests for the CCX dashboard.
"""
from nose.plugins.attrib import attr

from common.test.acceptance.fixtures.course import CourseFixture
from common.test.acceptance.tests.helpers import UniqueCourseTest, EventsTestMixin
from common.test.acceptance.pages.lms.auto_auth import AutoAuthPage
from common.test.acceptance.pages.lms.ccx_dashboard_page import CoachDashboardPage


@attr('shard_7')
class CreateCCXCoachTest(EventsTestMixin, UniqueCourseTest):
    """
    Test ccx end to end process.
    """
    USERNAME = "coach_tester"
    EMAIL = "coach_tester@example.com"

    def setUp(self):
        super(CreateCCXCoachTest, self).setUp()
        self.course_info.update({"settings": {"enable_ccx": "true"}})
        self.course_fixture = CourseFixture(**self.course_info).install()
        self.coach_dashboard_page = CoachDashboardPage(self.browser, self.course_id)

    def _auto_auth(self, username, email):
        """
        Logout and login with given credentials.
        """
        AutoAuthPage(self.browser, username=username, email=email,
                     course_id=self.course_id, staff=True).visit()

    def test_create_ccx(self):
        """
        Assert that ccx created.
        """
        ccx_name = "Test ccx"
        self._auto_auth(self.USERNAME, self.EMAIL)
        self.coach_dashboard_page.visit()

        self.coach_dashboard_page.fill_ccx_name_text_box(ccx_name)
        self.coach_dashboard_page.wait_for_page()

        # Assert that new ccx is created and we are on ccx dashboard/enrollment tab.
        self.assertTrue(self.coach_dashboard_page.is_browser_on_enrollment_page())
