/*
 * Decompiled with CFR 0.152.
 */
package GX;

import GX.GenexParams;
import Problems.Problem;
import Requirements.RequirementFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ConfigurationFileReader {
    private HashSet<Problem> problems = new HashSet();
    private GenexParams params = new GenexParams();

    public ConfigurationFileReader(File configFile) {
        if (configFile == null) {
            return;
        }
        if (!configFile.exists()) {
            return;
        }
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build(configFile);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (doc != null) {
            for (Element e : doc.getRootElement().getChildren()) {
                if (e.getName().equals("Problem")) {
                    this.problems.add(this.processProblem(e));
                }
                if (!e.getName().equals("Parameters")) continue;
                this.processParams(this.params, e);
            }
        }
    }

    private Problem processProblem(Element problemElement) {
        Problem p = new Problem();
        for (Element e : problemElement.getChildren()) {
            if (e.getName().equals("Name")) {
                p.setName(e.getTextTrim());
            }
            if (e.getName().equals("Number")) {
                p.setNumber(Integer.parseInt(e.getTextTrim()));
            }
            if (e.getName().equals("Description")) {
                p.setDescription(e.getTextTrim());
            }
            if (!e.getName().equals("Requirement")) continue;
            p.addRequirement(RequirementFactory.build(e));
        }
        return p;
    }

    private void processParams(GenexParams defaultParams, Element newParams) {
        for (Element e : newParams.getChildren()) {
            if (e.getName().equals("DNA_SEQUENCE")) {
                defaultParams.setDefaultDNA(this.onlyACGT(e.getTextTrim()));
            }
            if (e.getName().equals("PROMOTER")) {
                defaultParams.setPromoterSequence(this.onlyACGT(e.getTextTrim()));
            }
            if (e.getName().equals("PROMOTER_SPACING")) {
                defaultParams.setPromoterSpacing(Integer.parseInt(e.getTextTrim()));
            }
            if (e.getName().equals("TERMINATOR")) {
                defaultParams.setTerminatorSequence(this.onlyACGT(e.getTextTrim()));
            }
            if (e.getName().equals("INTRON_START")) {
                defaultParams.setIntronStartSequence(this.onlyAGCU(e.getTextTrim()));
            }
            if (e.getName().equals("INTRON_END")) {
                defaultParams.setIntronEndSequence(this.onlyAGCU(e.getTextTrim()));
            }
            if (e.getName().equals("POLY_A_TAIL")) {
                defaultParams.setPolyATail(e.getTextTrim());
            }
            if (!e.getName().equals("PRINTING")) continue;
            defaultParams.setAllowPrinting(Boolean.parseBoolean(e.getTextTrim()));
        }
    }

    private String onlyACGT(String s) {
        return s.replaceAll("[^AGCT]", "");
    }

    private String onlyAGCU(String s) {
        return s.replaceAll("[^AGCU]", "");
    }

    public HashSet<Problem> getProblems() {
        return this.problems;
    }

    public GenexParams getParams() {
        return this.params;
    }
}

