module("tinymce.plugins.Media", {
	setupModule: function() {
		QUnit.stop();

		tinymce.init({
			selector: "textarea",
			add_unload_trigger: false,
			skin: false,
			plugins: 'media',
			document_base_url: '/tinymce/tinymce/trunk/tests/',
			media_scripts: [
				{filter: 'http://media1.tinymce.com'},
				{filter: 'http://media2.tinymce.com', width: 100, height: 200}
			],
			init_instance_callback: function(ed) {
				window.editor = ed;
				QUnit.start();
			}
		});
	}
});

test("Object retain as is", function() {
	editor.setContent(
		'<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="425" height="355">' +
			'<param name="movie" value="someurl">' +
			'<param name="wmode" value="transparent">' +
			'<embed src="someurl" type="application/x-shockwave-flash" wmode="transparent" width="425" height="355" />' +
		'</object>'
	);

	equal(editor.getContent(),
		'<p><object width="425" height="355" classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000">' +
			'<param name="movie" value="someurl">' +
			'<param name="wmode" value="transparent">' +
			'<embed src="someurl" type="application/x-shockwave-flash" wmode="transparent" width="425" height="355" />' +
		'</object></p>'
	);
});

test("Embed retain as is", function() {
	editor.setContent(
		'<video src="320x240.ogg" autoplay loop controls>text<a href="#">link</a></video>'
	);

	equal(editor.getContent(),
		// IE produces a different attribute order for some odd reason, I love IE
		tinymce.isIE ?
			'<p><video width="300" height="150" controls="controls" loop="loop" autoplay="autoplay" src="320x240.ogg">text<a href="#">link</a></video></p>' :
			'<p><video width="300" height="150" src="320x240.ogg" autoplay="autoplay" loop="loop" controls="controls">text<a href="#">link</a></video></p>'
	);
});

test("Video retain as is", function() {
	editor.setContent(
		'<video src="320x240.ogg" autoplay loop controls>text<a href="#">link</a></video>'
	);

	equal(editor.getContent(),
		// IE produces a different attribute order for some odd reason, I love IE
		tinymce.isIE ?
			'<p><video width="300" height="150" controls="controls" loop="loop" autoplay="autoplay" src="320x240.ogg">text<a href="#">link</a></video></p>' :
			'<p><video width="300" height="150" src="320x240.ogg" autoplay="autoplay" loop="loop" controls="controls">text<a href="#">link</a></video></p>'
	);
});

test("Iframe retain as is", function() {
	editor.setContent(
		'<iframe src="320x240.ogg" allowfullscreen>text<a href="#">link</a></iframe>'
	);

	equal(editor.getContent(),
		'<p><iframe src="320x240.ogg" width="300" height="150" allowfullscreen="allowfullscreen">text<a href="#">link</a></iframe></p>'
	);
});

test("Audio retain as is", function() {
	editor.setContent(
		'<audio src="sound.mp3">' +
			'<track kind="captions" src="foo.en.vtt" srclang="en" label="English">' +
			'<track kind="captions" src="foo.sv.vtt" srclang="sv" label="Svenska">' +
			'text<a href="#">link</a>' +
		'</audio>'
	);

	equal(editor.getContent(),
		'<p>' +
			'<audio src="sound.mp3">' +
				'<track kind="captions" src="foo.en.vtt" srclang="en" label="English">' +
				'<track kind="captions" src="foo.sv.vtt" srclang="sv" label="Svenska">' +
				'text<a href="#">link</a>' +
			'</audio>' +
		'</p>'
	);
});

test("Resize complex object", function() {
	editor.setContent(
		'<video width="300" height="150" controls="controls">' +
			'<source src="s" />' +
			'<object type="application/x-shockwave-flash" data="../../js/tinymce/plugins/media/moxieplayer.swf" width="300" height="150">' +
				'<param name="allowfullscreen" value="true" />' +
				'<param name="allowscriptaccess" value="always" />' +
				'<param name="flashvars" value="video_src=s" />' +
				'<!--[if IE]><param name="movie" value="../../js/tinymce/plugins/media/moxieplayer.swf" /><![endif]-->' +
			'</object>' +
		'</video>'
	);

	var placeholderElm = editor.getBody().firstChild.firstChild;
	placeholderElm.width = 100;
	placeholderElm.height = 200;
	editor.fire('objectResized', {target: placeholderElm, width: placeholderElm.width, height: placeholderElm.height});

	equal(editor.getContent(),
		'<p>' +
			'<video width="100" height="200" controls="controls">' +
				'<source src="s" />' +
				'<object type="application/x-shockwave-flash" data="../../js/tinymce/plugins/media/moxieplayer.swf" width="100" height="200">' +
					'<param name="allowfullscreen" value="true" />' +
					'<param name="allowscriptaccess" value="always" />' +
					'<param name="flashvars" value="video_src=s" />' +
					'<!--[if IE]>' +
						'<param name="movie" value="../../js/tinymce/plugins/media/moxieplayer.swf" />' +
					'<![endif]-->' +
				'</object>' +
			'</video>' +
		'</p>'
	);
});

test("Media script elements", function() {
	editor.setContent(
		'<script src="http://media1.tinymce.com/123456"></sc'+'ript>' +
		'<script src="http://media2.tinymce.com/123456"></sc'+'ript>'
	);

	equal(editor.getBody().getElementsByTagName('img')[0].className, 'mce-object mce-object-script');
	equal(editor.getBody().getElementsByTagName('img')[0].width, 300);
	equal(editor.getBody().getElementsByTagName('img')[0].height, 150);
	equal(editor.getBody().getElementsByTagName('img')[1].className, 'mce-object mce-object-script');
	equal(editor.getBody().getElementsByTagName('img')[1].width, 100);
	equal(editor.getBody().getElementsByTagName('img')[1].height, 200);

	equal(editor.getContent(),
		'<p>\n' +
			'<script src="http://media1.tinymce.com/123456" type="text/javascript"></sc'+'ript>\n' +
			'<script src="http://media2.tinymce.com/123456" type="text/javascript"></sc'+'ript>\n' +
		'</p>'
	);
});
