/*
 * Decompiled with CFR 0.152.
 */
package Problems;

import Problems.GenexState;
import Requirements.Requirement;
import java.util.HashSet;
import java.util.Iterator;

public class Problem {
    private HashSet<Requirement> requirements = new HashSet();
    private String name;
    private int number;
    private String description;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    public void addRequirement(Requirement r) {
        this.requirements.add(r);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String evaluate(GenexState gs) {
        StringBuffer failBuffer = new StringBuffer();
        Iterator<Requirement> rIt = this.requirements.iterator();
        boolean satisfied = true;
        while (rIt.hasNext()) {
            Requirement r = rIt.next();
            if (r.isSatisfied(gs)) continue;
            satisfied = false;
            failBuffer.append(r.getFailureString());
            failBuffer.append("<br>");
        }
        if (satisfied) {
            return "OK";
        }
        return failBuffer.toString();
    }
}

