/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import protex.AminoAcidPalette;
import protex.FoldingWindow;
import protex.ProteinImageFactory;
import protex.ProteinImageSet;
import protex.Protex;
import protex.ShapeMatcher;

public class ProtexApplet
extends JApplet {
    private FoldingWindow foldingWindow;
    private Protex protex;
    private String targetShapeString;

    @Override
    public void init() {
        this.protex = new Protex(true);
        this.foldingWindow = new FoldingWindow("Folding Window", this.protex);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        JPanel aapPanel = new JPanel();
        aapPanel.setBorder(BorderFactory.createTitledBorder("Amino acids"));
        aapPanel.setLayout(new BoxLayout(aapPanel, 0));
        AminoAcidPalette aaPalette = new AminoAcidPalette(225, 180, 4, 5, false);
        aapPanel.setMaximumSize(new Dimension(250, 200));
        aapPanel.add(aaPalette);
        aapPanel.add(Box.createRigidArea(new Dimension(1, 180)));
        leftPanel.add(aapPanel);
        this.targetShapeString = this.getParameter("TARGET_SHAPE");
        if (this.targetShapeString != null) {
            ProteinImageSet pis = ProteinImageFactory.buildProtein(this.targetShapeString, false);
            JPanel targetPanel = new JPanel();
            targetPanel.setBorder(BorderFactory.createTitledBorder("Target Shape"));
            targetPanel.add(new JLabel(new ImageIcon(pis.getFullScaleImage())));
            leftPanel.add(targetPanel);
        }
        mainPanel.add(leftPanel);
        mainPanel.add(this.foldingWindow);
        this.getContentPane().add(mainPanel);
    }

    public String checkAnswer() {
        if (this.targetShapeString == null || this.targetShapeString.equals("")) {
            return "ERROR: No target shape specified.";
        }
        if (this.foldingWindow.getOutputPalette().getBackground().equals(Color.PINK)) {
            return "ERROR: The protein sequence you typed in has not been folded. Click the FOLD button and re-submit.";
        }
        if (this.foldingWindow.getOutputPalette().getDrawingPane().getGrid() == null) {
            return "ERROR: There is no folded protein to check.";
        }
        ShapeMatcher shapeMatcher = new ShapeMatcher(this.targetShapeString, false);
        if (shapeMatcher.matchesTarget(this.foldingWindow.getOutputPalette().getDrawingPane().getGrid().getPP().getDirectionSequence())) {
            return "CORRECT";
        }
        return "INCORRECT";
    }
}

