/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import protex.AcidInChain;
import protex.AminoAcid;
import protex.AminoAcidTable;
import protex.Direction;

public class Polypeptide
implements Serializable {
    private int id;
    private int numAcids;
    private boolean folded = false;
    private Color color;
    private String stringId = null;
    private double maxEnergy = 1.0;
    private AminoAcidTable table;
    private ArrayList acids;
    private AcidInChain[] acidArray;
    private Integer[] wrappers;

    public boolean isFolded() {
        return this.folded;
    }

    public String getId() {
        return this.stringId;
    }

    public Color getColor() {
        return this.color;
    }

    public int getLength() {
        return this.acids.size();
    }

    public Iterator iterator() {
        return this.acids.iterator();
    }

    public AminoAcidTable getTable() {
        return this.table;
    }

    public AcidInChain[] getAcidArray() {
        return this.acidArray;
    }

    public String getTopology() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.numAcids) {
            buf.append("\n" + i + ": " + this.acidArray[i].getNeighbors());
            ++i;
        }
        return buf.toString();
    }

    public Direction getNextDirection(int index) {
        return this.acidArray[index].next;
    }

    public AcidInChain getAminoAcid(int i) {
        return (AcidInChain)this.acids.get(i);
    }

    public String toString() {
        Iterator i = this.iterator();
        StringBuffer buf = new StringBuffer();
        while (i.hasNext()) {
            buf.append((AcidInChain)i.next() + " : ");
        }
        return buf.toString();
    }

    public String toCSV() {
        Iterator i = this.iterator();
        StringBuffer buf = new StringBuffer();
        while (i.hasNext()) {
            buf.append(String.valueOf(((AcidInChain)i.next()).getHydrophobicIndex()) + ", ");
        }
        return buf.toString();
    }

    public String toReport() {
        StringBuffer buf = new StringBuffer();
        buf.append("\n\tPolpeptide pp:         " + this.toString());
        buf.append("\n\tpp.getId():            " + this.getId());
        buf.append("\n\tpp.getColor():         " + this.getColor());
        return buf.toString();
    }

    public double getMaxEnergy() {
        return this.maxEnergy;
    }

    public String getDirectionSequence() {
        Iterator i = this.iterator();
        StringBuffer buf = new StringBuffer();
        while (i.hasNext()) {
            buf.append(((AcidInChain)i.next()).getNext() + ";");
        }
        buf.deleteCharAt(buf.length() - 1);
        return buf.toString();
    }

    public String getAcidAndDirectionSequence() {
        Iterator i = this.iterator();
        StringBuffer buf = new StringBuffer();
        Direction d = Direction.none;
        while (i.hasNext()) {
            AcidInChain a = (AcidInChain)i.next();
            buf.append(String.valueOf(a.getAbName()) + ":" + d.toString() + ";");
            d = a.getNext();
        }
        buf.deleteCharAt(buf.length() - 1);
        return buf.toString();
    }

    public void setFolded() {
        this.folded = true;
    }

    public void setId(String ppId) {
        this.stringId = ppId;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setNext(int index, Direction d) {
        this.acidArray[index].setNext(d);
    }

    public void addNeighbor(AcidInChain to, AcidInChain from) {
        to.addNeighbor(this.wrappers[this.acids.indexOf(from)]);
    }

    public void clearTopology() {
        int i = 0;
        while (i < this.numAcids) {
            this.acidArray[i].getNeighbors().clear();
            ++i;
        }
    }

    protected Polypeptide(AminoAcidTable table, int length, int seed, String id) {
        this(table, table.getRandom(length, seed), id);
    }

    protected Polypeptide(AminoAcidTable table, AminoAcid[] acids, Direction[] directions, String id) {
        this(table, acids, id);
        this.setDirections(directions);
    }

    protected Polypeptide(AminoAcidTable table, AminoAcid[] realAcids, String id) {
        this.stringId = id;
        this.table = table;
        this.maxEnergy = table.getMaxEnergy();
        this.acids = new ArrayList();
        int i = 0;
        while (i < realAcids.length) {
            this.acids.add(new AcidInChain(realAcids[i], i));
            ++i;
        }
        this.numAcids = this.acids.size();
        this.wrappers = new Integer[this.acids.size()];
        i = 0;
        while (i < this.wrappers.length) {
            this.wrappers[i] = new Integer(i);
            ++i;
        }
        this.acidArray = this.acids.toArray(new AcidInChain[0]);
    }

    protected void setDirections(Direction[] directions) {
        int i = 0;
        while (i < directions.length) {
            this.setNext(i, directions[i]);
            ++i;
        }
        this.folded = true;
    }
}

