/**
 * Legacy JavaScript for the student dashboard.
 * Please do not add anything else to this file unless
 * you have an extremely good reason.  New JavaScript
 * for the dashboard should be implemented as self-contained
 * modules with unit tests.
 */
 var edx = edx || {};

(function($, gettext, Logger, accessibleModal) {
    'use strict';

    edx.dashboard = edx.dashboard || {};
    edx.dashboard.legacy = {};

    /**
     * Initialize the dashboard using legacy JavaScript.
     *
     * @param{Object} urls - The URLs used by the JavaScript,
     *     which are generated by the server and passed into
     *     this function by the rendered page.
     *
     *     Specifically:
     *         - dashboard
     *         - signInUser
     *         - passwordReset
     *         - changeEmail
     *         - changeEmailSettings
     *         - changeName
     *         - verifyToggleBannerFailedOff
     */
    edx.dashboard.legacy.init = function(urls) {

        // On initialization, set focus to the first notification available
        // for screen readers.
        var notifications = $('.dashboard-notifications');
        if (notifications.children().length > 0) {
            notifications.focus();
        }

        $('.message.is-expandable .wrapper-tip').bind('click', toggleExpandMessage);

        function toggleExpandMessage(e) {
            (e).preventDefault();

            $(this).closest('.message.is-expandable').toggleClass('is-expanded');

            var course = $("#upgrade-to-verified").data("course-id");
            analytics.track('edx.bi.dashboard.upsell_copy.clicked', {
                category: 'user-engagement',
                label: course
            });
        }

        $("#failed-verification-button-dismiss").click(function() {
            $.ajax({
                url: urls.verifyToggleBannerFailedOff,
                type: "post"
            });
            $("#failed-verification-banner").addClass('is-hidden');
        });

        $("#upgrade-to-verified").click(function(event) {
            var user = $(event.target).data("user");
            var course = $(event.target).data("course-id");
            Logger.log('edx.course.enrollment.upgrade.clicked', [user, course], null);
        });

        $(".email-settings").click(function(event) {
            $("#email_settings_course_id").val( $(event.target).data("course-id") );
            $("#email_settings_course_number").text( $(event.target).data("course-number") );
            if($(event.target).data("optout") === "False") {
                $("#receive_emails").prop('checked', true);
            }
        });

        $(".unenroll").click(function(event) {
            $("#unenroll_course_id").val( $(event.target).data("course-id") );
            $("#unenroll_course_number").text( $(event.target).data("course-number") );
        });

        $('#unenroll_form').on('ajax:complete', function(event, xhr) {
            if(xhr.status === 200) {
                location.href = urls.dashboard;
            } else if (xhr.status === 403) {
                location.href = urls.signInUser + "?course_id=" +
                encodeURIComponent($("#unenroll_course_id").val()) + "&enrollment_action=unenroll";
            } else {
                $('#unenroll_error').html(
                    xhr.responseText ? xhr.responseText : gettext("An error occurred. Please try again later.")
                ).stop().css("display", "block");
            }
        });

        $('#pwd_reset_button').click(function() {
            $.post(
                urls.passwordReset,
                {"email"  : $('#id_email').val()},
                function() {
                    $("#password_reset_complete_link").click();
                }
            );
        });

        $("#submit-lang").click(function(event) {
            event.preventDefault();
            $.post('/lang_pref/setlang/',
                {language: $('#settings-language-value').val()}
            ).done(function() {
                // submit form as normal
                $('.settings-language-form').submit();
            });
        });

        $("#change_email_form").submit(function(){
            var new_email = $('#new_email_field').val();
            var new_password = $('#new_email_password').val();

            $.post(
                urls.changeEmail,
                {"new_email" : new_email, "password" : new_password},
                function(data) {
                    if (data.success) {
                        $("#change_email_title").html(gettext("Please verify your new email address"));
                        $("#change_email_form").html(
                            "<p>" +
                            gettext("You'll receive a confirmation in your inbox. Please follow the link in the email to confirm your email address change.") +
                            "</p>"
                        );
                    } else {
                        $("#change_email_error").html(data.error).stop().css("display", "block");
                    }
                }
            );
            return false;
        });

        $("#change_name_form").submit(function(){
            var new_name = $('#new_name_field').val();
            var rationale = $('#name_rationale_field').val();

            $.post(
                urls.changeName,
                {"new_name":new_name, "rationale":rationale},
                function(data) {
                    if(data.success) {
                        location.reload();
                    } else {
                        $("#change_name_error").html(data.error).stop().css("display", "block");
                    }
                }
            );
            return false;
        });

        $("#email_settings_form").submit(function(){
            $.ajax({
                type: "POST",
                url: urls.changeEmailSettings,
                data: $(this).serializeArray(),
                success: function(data) {
                    if(data.success) {
                        location.href = urls.dashboard;
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 403) {
                        location.href = urls.signInUser;
                    }
                }
            });
            return false;
        });

        accessibleModal(
            ".edit-name",
            "#apply_name_change .close-modal",
            "#apply_name_change",
            "#dashboard-main"
        );
        accessibleModal(
            ".edit-email",
            "#change_email .close-modal",
            "#change_email",
            "#dashboard-main"
        );
        accessibleModal(
            "#pwd_reset_button",
            "#password_reset_complete .close-modal",
            "#password_reset_complete",
            "#dashboard-main"
        );

        $(".email-settings").each(function(index){
            $(this).attr("id", "unenroll-" + index);
            // a bit of a hack, but gets the unique selector for the modal trigger
            var trigger = "#" + $(this).attr("id");
            accessibleModal(
                trigger,
                "#email-settings-modal .close-modal",
                "#email-settings-modal",
                "#dashboard-main"
            );
        });

        $(".unenroll").each(function(index){
            $(this).attr("id", "email-settings-" + index);
            // a bit of a hack, but gets the unique selector for the modal trigger
            var trigger = "#" + $(this).attr("id");
            accessibleModal(
                trigger,
                "#unenroll-modal .close-modal",
                "#unenroll-modal",
                "#dashboard-main"
            );
        });

        $("#unregister_block_course").click( function(event) {
            $("#unenroll_course_id").val($(event.target).data("course-id"));
            $("#unenroll_course_number").text($(event.target).data("course-number"));
        });
    };

})(jQuery, gettext, Logger, accessible_modal);
