/*
 * Decompiled with CFR 0.152.
 */
package protex;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import protex.FoldingWindow;
import protex.StandardTable;

public class TripleLetterCodeDocument
extends DefaultStyledDocument {
    final String allowedLetters = "ACDEFGHIKLMNPQRSTVWY";
    private FoldingWindow foldingWindow = null;
    private StandardTable table = StandardTable.getInstance();

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String ucString = str.toUpperCase();
        char[] chars = ucString.toCharArray();
        int i = chars.length - 1;
        while (i >= 0) {
            String s = String.valueOf(chars[i]);
            if ("ACDEFGHIKLMNPQRSTVWY".indexOf(s) != -1) {
                String name = this.table.getFromAbName(s).getName();
                int newOffset = offs % 4 > 1 ? offs - offs % 4 + 4 : offs - offs % 4;
                super.insertString(newOffset, String.valueOf(name) + " ", a);
            }
            --i;
        }
        this.foldingWindow.aaSeqChanged();
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        this.foldingWindow.aaSeqChanged();
        int placeInAaName = offs % 4;
        int numOfAAsSelected = (offs + (len - 1)) / 4 - offs / 4 + 1;
        super.remove(offs - placeInAaName, 4 * numOfAAsSelected);
    }

    public void removeAll() {
        try {
            super.remove(0, this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void setLinkedFoldingWindow(FoldingWindow fw) {
        this.foldingWindow = fw;
    }
}

