/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.awt.Polygon;
import protex.Grid;
import protex.GridCanvas;
import protex.GridPoint;

public class HexCanvas
extends GridCanvas {
    private static final int sqrt3 = (int)Math.sqrt(3.0);
    private int cellHeight;
    private Polygon hexagon;

    public HexCanvas(int width, int height) {
        super(width, height);
        this.cellHeight = (int)((double)this.cellRadius * Math.sqrt(3.0));
        this.createHexagon();
    }

    public HexCanvas() {
        this.cellHeight = (int)((double)this.cellRadius * Math.sqrt(3.0));
        this.createHexagon();
    }

    private void createHexagon() {
        this.hexagon = new Polygon();
        this.hexagon.addPoint(this.cellRadius / 2, 0);
        this.hexagon.addPoint(3 * this.cellRadius / 2, 0);
        this.hexagon.addPoint(2 * this.cellRadius, sqrt3 * this.cellRadius);
        this.hexagon.addPoint(3 * this.cellRadius / 2, 2 * sqrt3 * this.cellRadius);
        this.hexagon.addPoint(this.cellRadius / 2, 2 * sqrt3 * this.cellRadius);
        this.hexagon.addPoint(0, sqrt3 * this.cellRadius);
    }

    @Override
    protected void setGrid(Grid grid) {
        super.setGrid(grid);
    }

    @Override
    protected int getAcidRadius() {
        return this.cellRadius;
    }

    @Override
    protected GridPoint project(GridPoint p) {
        GridPoint spot = new GridPoint((1 + 2 * p.x + p.y) * this.cellRadius, p.y * this.cellHeight + this.cellRadius);
        return spot;
    }
}

