/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.text.DecimalFormat;
import java.util.Vector;
import protex.Attributes;
import protex.BruteForceFolder;
import protex.Folder;
import protex.FoldingException;
import protex.Grid;
import protex.GridCanvas;
import protex.HexCanvas;
import protex.HexGrid;
import protex.IncrementalFolder;
import protex.OutputPalette;
import protex.Polypeptide;
import protex.PolypeptideFactory;
import protex.TwoDGrid;

public class FoldingManager {
    private int lastPPId;
    private static FoldingManager instance;
    private PolypeptideFactory factory;
    private Vector observers = new Vector();
    private Attributes currentAttrib;
    private Polypeptide currentPP;
    private Folder currentFolder;
    private Grid currentGrid;
    private TwoDGrid hexagonalCore;
    private boolean isPlotting = false;
    protected boolean DEBUG = false;

    public static FoldingManager getInstance() {
        if (instance == null) {
            instance = new FoldingManager();
        }
        return instance;
    }

    public Polypeptide getPolypeptide() {
        return this.currentPP;
    }

    public int getLastPPId() {
        return this.lastPPId;
    }

    public String getEnergyString() {
        return String.valueOf(this.currentGrid.getEnergy(this.currentFolder.custom, this.currentFolder.hpIndex, this.currentFolder.hIndex, this.currentFolder.iIndex, this.currentFolder.sIndex));
    }

    public String getEnergyString(String pattern) {
        return this.getEnergy(pattern);
    }

    public String getEnergy(String pattern) {
        DecimalFormat formatter = new DecimalFormat(pattern);
        return formatter.format(this.getEnergy());
    }

    public double getEnergy() {
        return this.currentGrid.getEnergy(this.currentFolder.custom, this.currentFolder.hpIndex, this.currentFolder.hIndex, this.currentFolder.iIndex, this.currentFolder.sIndex);
    }

    public String getFoldingIndex(String pattern) {
        DecimalFormat formatter = new DecimalFormat(pattern);
        return formatter.format(this.getFoldingIndex());
    }

    public String getFoldingIndexString() {
        return "" + this.getFoldingIndex();
    }

    public double getFoldingIndex() {
        return this.currentGrid.getFoldingIndex(this.currentFolder.custom, this.currentFolder.hpIndex, this.currentFolder.hIndex, this.currentFolder.iIndex, this.currentFolder.sIndex);
    }

    public String getTopology() {
        return this.currentPP.getTopology();
    }

    public long getTime() {
        if (this.isPlotting) {
            return 0L;
        }
        return this.currentFolder.getTime();
    }

    public String report() {
        if (this.isPlotting) {
            StringBuffer buf = new StringBuffer();
            buf.append("\n Polypeptide:   " + this.getPolypeptide().toString());
            buf.append("\n Energy:        " + this.getEnergy());
            buf.append("\n Folding index: " + this.getFoldingIndex());
            return buf.toString();
        }
        return "\n" + this.currentFolder.report();
    }

    public String actionReport() {
        StringBuffer buf = new StringBuffer();
        if (this.isPlotting) {
            buf.append("Plotted Solution");
        } else {
            buf.append("\n");
            if (this.currentAttrib.getIsRandom()) {
                buf.append("Randomly generated with length:   ");
                buf.append(this.currentAttrib.getLength());
                buf.append("   and seed:  " + this.currentAttrib.getSeed());
            } else {
                buf.append(" Polypeptide was parsed from input");
            }
            buf.append("\n");
            if (this.currentAttrib.getFolder().equalsIgnoreCase("bruteForce")) {
                buf.append(" Brute Force Algorithm");
            } else {
                buf.append(" Incremental  ");
                buf.append("   look-ahead: " + this.currentAttrib.getLookup());
                buf.append("   step: " + this.currentAttrib.getStep());
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public void setLastPPId(int id) {
        this.lastPPId = id;
    }

    public static String assignPPId(int id) {
        String stringId = id > 100 ? "PP" + new Integer(id).toString() : (id > 10 ? "PP0" + new Integer(id).toString() : "PP00" + new Integer(id).toString());
        if (FoldingManager.getInstance().DEBUG) {
            System.out.println("\nHistoryCellRenderer: Value assigned, stringId = " + stringId);
        }
        return stringId;
    }

    public void setDEBUG(boolean flag) {
        this.DEBUG = flag;
    }

    public void fold(Attributes attrib) throws FoldingException {
        this.resetCurrent();
        this.currentAttrib = attrib;
        this.foldPP(attrib);
    }

    public GridCanvas createCanvas(int width, int height) {
        HexCanvas canvas;
        String grid = this.currentAttrib.getGrid();
        if (grid.equalsIgnoreCase("hexagonal")) {
            canvas = new HexCanvas();
        } else {
            canvas = null;
            System.out.print("\nFoldingManager.createCanvas(): ");
            System.out.println("Could not create canvas. Grid argument failed.");
        }
        ((GridCanvas)canvas).setGrid(this.currentGrid);
        return canvas;
    }

    public void createCanvas(OutputPalette outputPanel) {
        outputPanel.getDrawingPane().repaint();
        outputPanel.getDrawingPane().setGrid(this.currentGrid);
    }

    private FoldingManager() {
        this.factory = PolypeptideFactory.getInstance();
        this.resetCurrent();
    }

    private void resetCurrent() {
        this.isPlotting = false;
        this.currentAttrib = null;
        this.currentPP = null;
        this.currentFolder = null;
        this.currentGrid = null;
    }

    private void foldPP(Attributes attrib) throws FoldingException {
        this.createPP(attrib);
        this.createGrid(attrib);
        this.createFolder(attrib);
        this.currentFolder.fold();
    }

    private void createPP(Attributes attrib) throws FoldingException {
        try {
            this.currentPP = this.factory.createPolypeptide(attrib.getInputString(), attrib.getIsFolded(), attrib.getIsRandom(), attrib.getLength(), attrib.getSeed(), attrib.getTable(), attrib.getNumAALetterCode(), attrib.getPpId());
        }
        catch (FoldingException ex) {
            throw new FoldingException("Polypeptide Creation: " + ex.getMessage());
        }
    }

    private void createGrid(Attributes attrib) throws FoldingException {
        String grid = attrib.getGrid();
        if (!grid.equalsIgnoreCase("hexagonal")) {
            throw new FoldingException("FoldingManager.createGrid(): REQUIRED: hexagonal. GIVEN: " + grid);
        }
        this.currentGrid = new HexGrid(this.currentPP);
    }

    private void createFolder(Attributes attrib) throws FoldingException {
        String folder = attrib.getFolder();
        if (folder.equalsIgnoreCase("bruteforce")) {
            this.currentFolder = new BruteForceFolder(attrib.isCustom(), this.currentPP, this.currentGrid);
        } else if (folder.equalsIgnoreCase("incremental")) {
            this.currentFolder = new IncrementalFolder(attrib.isCustom(), this.currentPP, this.currentGrid);
            String lookupString = attrib.getLookup();
            String stepString = attrib.getStep();
            String hpIndexString = attrib.getHydroPhobicIndex();
            String hIndexString = attrib.getHydrogenIndex();
            String iIndexString = attrib.getIonicIndex();
            String sIndexString = attrib.getssBondIndex();
            int lookup = 0;
            int step = 0;
            double hpIndex = 0.0;
            double hIndex = 0.0;
            double iIndex = 0.0;
            double sIndex = 0.0;
            try {
                lookup = Integer.parseInt(lookupString);
            }
            catch (NumberFormatException ex) {
                throw new FoldingException("FolderCreation: look ahead: REQUIRED: integer GIVEN: " + lookupString);
            }
            if (lookup <= 0) {
                throw new FoldingException("FolderCreation: look ahead: REQUIRED: positive no GIVEN: " + lookup);
            }
            try {
                step = Integer.parseInt(stepString);
            }
            catch (NumberFormatException ex) {
                throw new FoldingException("FolderCreation: step: REQUIRED: integer GIVEN: " + stepString);
            }
            if (step <= 0) {
                throw new FoldingException("FolderCreation: step: REQUIRED: positive no GIVEN: " + step);
            }
            try {
                hpIndex = Double.parseDouble(hpIndexString);
            }
            catch (NumberFormatException ex) {
                throw new FoldingException("FolderCreation: HydroutputPanelhobic Index: REQUIRED: double GIVEN: " + hpIndexString);
            }
            try {
                hIndex = Double.parseDouble(hIndexString);
            }
            catch (NumberFormatException ex) {
                throw new FoldingException("FolderCreation: HydrogenBond Index: REQUIRED: double GIVEN: " + hIndexString);
            }
            try {
                iIndex = Double.parseDouble(iIndexString);
            }
            catch (NumberFormatException ex) {
                throw new FoldingException("FolderCreation: Ionic Index: REQUIRED: double GIVEN: " + iIndexString);
            }
            try {
                sIndex = Double.parseDouble(sIndexString);
            }
            catch (NumberFormatException ex) {
                throw new FoldingException("FolderCreation: ssBond Index: REQUIRED: double GIVEN: " + sIndexString);
            }
            ((IncrementalFolder)this.currentFolder).setLookAhead(lookup);
            ((IncrementalFolder)this.currentFolder).setStep(step);
            this.currentFolder.setHydroPhobicIndex(hpIndex);
            this.currentFolder.setHydrogenIndex(hIndex);
            this.currentFolder.setIonicIndex(iIndex);
            this.currentFolder.setssBondIndex(sIndex);
        } else {
            throw new FoldingException("Folder creation: REQUIRED: bruteforce OR incremental. GIVEN: " + folder);
        }
    }
}

