/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.text.DecimalFormat;
import protex.AcidInChain;
import protex.Grid;
import protex.Polypeptide;

public abstract class Folder {
    protected boolean custom;
    protected Grid grid;
    protected static final double defaultHydroPhobicIndex = 1.0;
    protected static final double defaultHydrogenIndex = 1.0;
    protected static final double defaultIonicIndex = 1.0;
    protected static final double defaultssBondIndex = 0.0;
    protected double hpIndex = 1.0;
    protected double hIndex = 1.0;
    protected double iIndex = 1.0;
    protected double sIndex = 0.0;
    protected Polypeptide pp;
    private long time;
    protected DecimalFormat formatter = new DecimalFormat("####.####");
    protected AcidInChain[] acids;
    protected int numAcids;

    public Folder(boolean custom, Polypeptide pp, Grid grid) {
        this.custom = custom;
        this.grid = grid;
        this.pp = pp;
        this.numAcids = pp.getLength();
        this.acids = pp.getAcidArray();
    }

    public void fold() {
        this.time = System.currentTimeMillis();
        this.realFold();
        this.time = System.currentTimeMillis() - this.time;
        this.grid.computeStatistics(this.custom, this.hpIndex, this.hIndex, this.iIndex, this.sIndex);
        this.pp.setFolded();
    }

    public abstract void realFold();

    public abstract String getStatistics();

    public abstract String getName();

    public void setHydroPhobicIndex(double hpIndex) {
        this.hpIndex = hpIndex;
    }

    public void setHydrogenIndex(double hIndex) {
        this.hIndex = hIndex;
    }

    public void setIonicIndex(double iIndex) {
        this.iIndex = iIndex;
    }

    public void setssBondIndex(double sIndex) {
        this.sIndex = sIndex;
    }

    public String report() {
        StringBuffer buf = new StringBuffer(this.getName());
        buf.append("\n" + this.pp.toString());
        buf.append("\nenergy " + this.formatter.format(this.grid.getEnergy(this.custom, this.hpIndex, this.hIndex, this.iIndex, this.sIndex)));
        buf.append("\nfolding index " + this.formatter.format(this.grid.getFoldingIndex(this.custom, this.hpIndex, this.hIndex, this.iIndex, this.sIndex)));
        buf.append("\ntime   " + this.getTime() + " seconds");
        buf.append("\ntopology " + this.pp.getTopology());
        return buf.toString();
    }

    public String csvReport() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.formatter.format(this.grid.getEnergy(this.custom, this.hpIndex, this.hIndex, this.iIndex, this.sIndex)));
        buf.append(", " + this.formatter.format(this.grid.getFoldingIndex(this.custom, this.hpIndex, this.hIndex, this.iIndex, this.sIndex)));
        buf.append(", " + this.pp.getDirectionSequence());
        buf.append(", " + this.pp.toCSV());
        return buf.toString();
    }

    public String getTopology() {
        return this.pp.getTopology();
    }

    public long getTime() {
        return this.time / 1000L;
    }

    public double getEnergy() {
        return this.grid.getEnergy(this.custom, this.hpIndex, this.hIndex, this.hIndex, this.sIndex);
    }
}

