#   Copyright (c) 2008 Mikeal Rogers
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

from mako.template import Template as MakoTemplate

from . import middleware

django_variables = ['lookup', 'template_dirs', 'output_encoding',
                    'module_directory', 'encoding_errors']


class Template(MakoTemplate):
    def __init__(self, *args, **kwargs):
        """Overrides base __init__ to provide django variable overrides"""
        if not kwargs.get('no_django', False):
            overrides = dict([(k, getattr(middleware, k, None),) for k in django_variables])
            kwargs.update(overrides)
        super(Template, self).__init__(*args, **kwargs)
